/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.global;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.element.IGenerationElementConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.element.IGenerationElementDependeciesConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.element.IGenerationElementInnerConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.global.GenerationConfigurationConstants;

public class GenerationConfigurationRegistry
implements GenerationConfigurationConstants {
    private static List<IGenerationElementInnerConfiguration> innerConfigurationRegistry = new ArrayList<IGenerationElementInnerConfiguration>();
    private static List<IGenerationElementDependeciesConfiguration> dependenciesRegistry = new ArrayList<IGenerationElementDependeciesConfiguration>();

    public static void unregisterAll() {
        innerConfigurationRegistry.clear();
        dependenciesRegistry.clear();
    }

    public static void register(IGenerationElementInnerConfiguration configuration) {
        if (!innerConfigurationRegistry.contains(configuration)) {
            innerConfigurationRegistry.add(configuration);
        }
    }

    public static void unregister(IGenerationElementInnerConfiguration configuration) {
        if (innerConfigurationRegistry.contains(configuration)) {
            innerConfigurationRegistry.remove(configuration);
        }
    }

    public static void register(IGenerationElementDependeciesConfiguration configuration) {
        if (!dependenciesRegistry.contains(configuration)) {
            dependenciesRegistry.add(configuration);
        }
    }

    public static void unregister(IGenerationElementDependeciesConfiguration configuration) {
        if (dependenciesRegistry.contains(configuration)) {
            dependenciesRegistry.remove(configuration);
        }
    }

    public static void initConfigurationExtensionRegistry() throws CoreException {
        IExtension[] tExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.GenerationElementConf").getExtensions();
        if (tExtensions.length > 0) {
            IExtension[] iExtensionArray = tExtensions;
            int n = tExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension iExtension = iExtensionArray[n2];
                IConfigurationElement[] configurationElements = iExtension.getConfigurationElements();
                if (configurationElements.length > 0) {
                    IConfigurationElement[] iConfigurationElementArray = configurationElements;
                    int n3 = configurationElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n4];
                        if (iConfigurationElement.getName().equals("inner")) {
                            IGenerationElementInnerConfiguration configuration = (IGenerationElementInnerConfiguration)iConfigurationElement.createExecutableExtension("class");
                            GenerationConfigurationRegistry.register(configuration);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public static IGenerationElementInnerConfiguration getInnerConfigurationFor(GenerationElement element) {
        for (IGenerationElementInnerConfiguration configuration : innerConfigurationRegistry) {
            if (!GenerationConfigurationRegistry.checkConfigurationClass(element, configuration)) continue;
            return configuration;
        }
        return null;
    }

    public static IGenerationElementDependeciesConfiguration getDependenciesConfigurationFor(GenerationElement element) {
        for (IGenerationElementDependeciesConfiguration configuration : dependenciesRegistry) {
            if (!GenerationConfigurationRegistry.checkConfigurationClass(element, configuration)) continue;
            return configuration;
        }
        return null;
    }

    private static boolean checkConfigurationClass(GenerationElement element, IGenerationElementConfiguration configuration) {
        Class<? extends GenerationElement> clazz = configuration.getElementClass();
        if (element.getClass().equals(clazz)) {
            return true;
        }
        Class<?>[] classArray = element.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            if (interfaze.equals(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

