/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.sequenceLink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.validation.sequenceLink.SequenceLinkEndStatusHelper;
import org.polarsys.capella.core.model.helpers.SequenceLinkExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class SequenceLinkWithInconsistentAssociatedLinks
extends AbstractValidationRule {
    public static final String SequenceLink_Inconsistent_Associated_FCIL = "(SequenceLink) between {0}({1}) and {2}({3}) has inconsistent associated {4}(FunctionalChainInvolvementLink).";

    public IStatus validate(IValidationContext ctx) {
        SequenceLink seqLink;
        EList associatedLinks;
        ArrayList<ConstraintStatus> statuses = new ArrayList<ConstraintStatus>();
        if (ctx.getEventType() == EMFEventType.NULL && ctx.getTarget() instanceof SequenceLink && !(associatedLinks = (seqLink = (SequenceLink)ctx.getTarget()).getLinks()).isEmpty()) {
            Set slClosestFCIFSources = SequenceLinkExt.findClosestSemanticFCIFunctionsAsSources((SequenceLink)seqLink);
            Set slClosestFCIFTargets = SequenceLinkExt.findClosestSemanticFCIFunctionsAsTargets((SequenceLink)seqLink);
            for (FunctionalChainInvolvementLink link : associatedLinks) {
                if (!(link.getInvolved() instanceof FunctionalExchange) || this.isValid(link, slClosestFCIFSources, slClosestFCIFTargets)) continue;
                Object[] argMessages = ArrayUtils.addAll((Object[])SequenceLinkEndStatusHelper.getStatusInfo(seqLink.getSource()), (Object[])SequenceLinkEndStatusHelper.getStatusInfo(seqLink.getTarget()));
                argMessages = ArrayUtils.add((Object[])argMessages, (Object)((FunctionalExchange)link.getInvolved()).getName());
                statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)seqLink, Arrays.asList(seqLink, link), (String)this.getMessagePattern(), (Object[])argMessages));
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected boolean isValid(FunctionalChainInvolvementLink link, Set<FunctionalChainInvolvementFunction> slClosestFCIFSources, Set<FunctionalChainInvolvementFunction> slClosestFCIFTargets) {
        return slClosestFCIFSources.contains(link.getSource()) && slClosestFCIFTargets.contains(link.getTarget()) || this.checkConditionOppositeDirection(link, slClosestFCIFSources, slClosestFCIFTargets);
    }

    protected boolean checkConditionOppositeDirection(FunctionalChainInvolvementLink link, Set<FunctionalChainInvolvementFunction> slClosestFCIFSources, Set<FunctionalChainInvolvementFunction> slClosestFCIFTargets) {
        return slClosestFCIFSources.contains(link.getTarget()) && slClosestFCIFTargets.contains(link.getSource());
    }

    protected String getMessagePattern() {
        return SequenceLink_Inconsistent_Associated_FCIL;
    }
}

