/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.log.EvalFailure;
import org.eclipse.sirius.query.legacy.gen.template.eval.log.EvalLog;
import org.osgi.framework.BundleContext;

public class AcceleoInterpreterPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.sirius.query.legacy";
    private static AcceleoInterpreterPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AcceleoInterpreterPlugin getDefault() {
        return plugin;
    }

    public void error(String message, Throwable t) {
        Status status = new Status(4, PLUGIN_ID, message, t);
        this.getLog().log((IStatus)status);
    }

    public void warning(String message, Throwable t) {
        Status status = new Status(2, PLUGIN_ID, message, t);
        this.getLog().log((IStatus)status);
    }

    public void info(String message) {
        Status status = new Status(1, PLUGIN_ID, message);
        this.getLog().log((IStatus)status);
    }

    public void logENode(ENode node, IStatus subStatus) {
        EvalLog evalLog = node.log();
        MultiStatus bigStatus = new MultiStatus(this.getBundle().getSymbolicName(), 4, "Error while evaluating Acceleo expression", (Throwable)new RuntimeException(evalLog.toString()));
        if (!evalLog.isOk()) {
            Iterator iterErrors = evalLog.allOrderedErrorsAndSevereWarnings();
            while (iterErrors.hasNext()) {
                EvalFailure failure = (EvalFailure)iterErrors.next();
                Status status = new Status(1, this.getBundle().getSymbolicName(), failure.getMessage());
                bigStatus.add((IStatus)status);
            }
            if (subStatus != null) {
                if (subStatus.isMultiStatus()) {
                    bigStatus.addAll(subStatus);
                } else {
                    bigStatus.add(subStatus);
                }
            }
        }
        this.getLog().log((IStatus)bigStatus);
    }
}

