/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.eval;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.query.legacy.ecore.factories.EFactory;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateElement;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.gen.template.eval.TextModelMapping;
import org.eclipse.sirius.query.legacy.gen.template.eval.TextTemplateElementMapping;
import org.eclipse.sirius.query.legacy.gen.template.eval.log.EvalLog;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class ENode
implements Comparable {
    protected Object value;
    protected String type;
    protected static final String T_EObject = "EObject";
    protected static final String T_ENodeList = "ENodeList";
    protected static final String T_String = "String";
    protected static final String T_boolean = "boolean";
    protected static final String T_int = "int";
    protected static final String T_double = "double";
    protected static final String T_null = "null";
    protected Class typeClass;
    protected EObject containerEObject;
    protected TemplateElement containerTemplateElement;
    protected TextModelMapping textModelMapping;
    protected TextTemplateElementMapping textTemplateElementMapping;
    protected EvalLog log = new EvalLog();
    private boolean synchronize = true;
    public static final EObject EMPTY = null;
    protected boolean containment = true;
    protected boolean optional = false;

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Class getTypeClass() {
        return this.typeClass;
    }

    public EObject getContainerEObject() {
        return this.containerEObject;
    }

    public TemplateElement getContainerTemplateElement() {
        return this.containerTemplateElement;
    }

    public TextModelMapping getTextModelMapping() {
        return this.textModelMapping;
    }

    public TextTemplateElementMapping getTextTemplateElementMapping() {
        return this.textTemplateElementMapping;
    }

    public EvalLog log() {
        return this.log;
    }

    @Deprecated
    public ENode(EObject object) {
        this(object, null, true);
    }

    public ENode(EObject object, TemplateElement element, boolean synchronize) {
        this.containerEObject = object;
        this.containerTemplateElement = element;
        this.synchronize = synchronize;
        this.init(object, T_EObject, EObject.class);
    }

    public ENode(EObject object, ENode parent) {
        this.init(parent);
        this.init(object, T_EObject, EObject.class);
    }

    public ENode(EObject object, EObject parent, TemplateElement element, boolean synchronize) {
        this(object, new ENode(parent, element, synchronize));
    }

    public ENode(ENodeList l, ENode parent) {
        this.init(parent);
        this.init(l, T_ENodeList, ENodeList.class);
    }

    public ENode(String s, ENode parent) {
        this.init(parent);
        this.init(s, T_String, String.class);
    }

    public ENode(boolean b, ENode parent) {
        this.init(parent);
        this.init(new Boolean(b), T_boolean, Boolean.TYPE);
    }

    public ENode(int i, ENode parent) {
        this.init(parent);
        this.init(new Integer(i), T_int, Integer.TYPE);
    }

    public ENode(double i, ENode parent) {
        this.init(parent);
        this.init(new Double(i), T_double, Double.TYPE);
    }

    protected void init(ENode parent) {
        if (parent != null) {
            this.synchronize = parent.synchronize;
            this.containerEObject = parent.containerEObject;
            this.containerTemplateElement = parent.containerTemplateElement;
            this.log.getAll(parent.log, false);
        }
    }

    protected void init(Object value, String type, Class typeClass) {
        if (value != null) {
            this.value = value;
            this.type = type;
            this.typeClass = typeClass;
        } else {
            this.value = null;
            this.type = T_null;
            this.typeClass = null;
        }
        this.textModelMapping = this.createTextModelMapping();
        this.textTemplateElementMapping = this.createTextTemplateElementMapping();
    }

    protected TextModelMapping createTextModelMapping() {
        if (this.isString() && this.containerEObject != null) {
            TextModelMapping mapping = new TextModelMapping(this.containerEObject, !this.synchronize);
            mapping.shift(((String)this.value).length());
            return mapping;
        }
        return null;
    }

    protected TextTemplateElementMapping createTextTemplateElementMapping() {
        if (this.isString() && this.containerTemplateElement != null) {
            TextTemplateElementMapping mapping = new TextTemplateElementMapping(this.containerTemplateElement, !this.synchronize);
            mapping.shift(((String)this.value).length());
            return mapping;
        }
        return null;
    }

    public boolean isEObject() {
        return this.type == T_EObject;
    }

    public boolean isList() {
        return this.type == T_ENodeList;
    }

    public boolean isString() {
        return this.type == T_String;
    }

    public boolean isBoolean() {
        return this.type == T_boolean;
    }

    public boolean isInt() {
        return this.type == T_int;
    }

    public boolean isDouble() {
        return this.type == T_double;
    }

    public boolean isNull() {
        return this.type == T_null;
    }

    public static Class getAdapterType(Class c) {
        if (c == ENode.class || c == EObject.class || c == ENodeList.class || c == String.class || c == Boolean.TYPE || c == Integer.TYPE || c == Double.TYPE || c == null) {
            return c;
        }
        if (EObject.class.isAssignableFrom(c)) {
            return EObject.class;
        }
        if (c == List.class) {
            return List.class;
        }
        if (c == Collection.class) {
            return List.class;
        }
        return null;
    }

    public Object getAdapterValue(Class c) throws ENodeCastException {
        if (c == EObject.class) {
            return this.toEObject_().getValue();
        }
        if (c == ENodeList.class) {
            return this.toList_().getValue();
        }
        if (c == String.class) {
            return this.toString_().getValue();
        }
        if (c == Boolean.TYPE) {
            return this.toBoolean_().getValue();
        }
        if (c == Integer.TYPE) {
            return this.toInt_().getValue();
        }
        if (c == Double.TYPE) {
            return this.toDouble_().getValue();
        }
        if (c == null) {
            return this.toNull_().getValue();
        }
        if (c == List.class) {
            return this.toList_().getList().asList();
        }
        if (c == Collection.class) {
            return this.toList_().getList().asList();
        }
        if (c == ENode.class) {
            return this;
        }
        throw new ENodeCastException(AcceleoGenMessages.getString("ENode.InvalidAdapterType", new Object[]{c.getClass().getName()}));
    }

    private ENode toEObject_() throws ENodeCastException {
        if (this.typeClass == EObject.class) {
            return this;
        }
        if (this.typeClass == ENodeList.class) {
            if (this.getList().size() > 0) {
                return this.getList().get(0);
            }
            return new ENode(EMPTY, this);
        }
        if (this.typeClass == String.class) {
            Object result = EcoreFactory.eINSTANCE.createFromString(EcorePackage.eINSTANCE.getEString(), this.getString());
            if (result instanceof EObject) {
                return new ENode((EObject)result, this);
            }
            return new ENode(EMPTY, this);
        }
        if (this.typeClass == Boolean.TYPE) {
            Object result = EcoreFactory.eINSTANCE.createFromString(EcorePackage.eINSTANCE.getEBoolean(), this.toString());
            if (result instanceof EObject) {
                return new ENode((EObject)result, this);
            }
            return new ENode(EMPTY, this);
        }
        if (this.typeClass == Integer.TYPE) {
            Object result = EcoreFactory.eINSTANCE.createFromString(EcorePackage.eINSTANCE.getEInt(), this.toString());
            if (result instanceof EObject) {
                return new ENode((EObject)result, this);
            }
            return new ENode(EMPTY, this);
        }
        if (this.typeClass == Double.TYPE) {
            Object result = EcoreFactory.eINSTANCE.createFromString(EcorePackage.eINSTANCE.getEDouble(), this.toString());
            if (result instanceof EObject) {
                return new ENode((EObject)result, this);
            }
            return new ENode(EMPTY, this);
        }
        return new ENode(EMPTY, this);
    }

    private ENode toList_() {
        if (this.typeClass == ENodeList.class) {
            return this;
        }
        ENodeList result = new ENodeList();
        result.add(this);
        return new ENode(result, this);
    }

    private ENode toString_() throws ENodeCastException {
        if (this.typeClass == String.class) {
            return this;
        }
        if (this.typeClass == ENodeList.class) {
            ENode result = new ENode("", this);
            ENodeIterator it = this.getList().iterator();
            while (it.hasNext()) {
                result.append(it.next());
            }
            return result;
        }
        return new ENode(this.toString(), this);
    }

    private ENode toBoolean_() throws ENodeCastException {
        if (this.typeClass == EObject.class) {
            return new ENode(true, this);
        }
        if (this.typeClass == ENodeList.class) {
            return new ENode(this.getList().size() > 0, this);
        }
        if (this.typeClass == String.class) {
            return new ENode("true".equalsIgnoreCase(this.getString().trim()), this);
        }
        if (this.typeClass == Boolean.TYPE) {
            return this;
        }
        if (this.typeClass == Integer.TYPE) {
            if (this.getInt() > 0) {
                return new ENode(true, this);
            }
            return new ENode(false, this);
        }
        if (this.typeClass == Double.TYPE) {
            if (this.getDouble() > 0.0) {
                return new ENode(true, this);
            }
            return new ENode(false, this);
        }
        return new ENode(false, this);
    }

    private ENode toInt_() throws ENodeCastException {
        if (this.typeClass == EObject.class) {
            return new ENode(1, this);
        }
        if (this.typeClass == ENodeList.class) {
            return new ENode(this.getList().size(), this);
        }
        if (this.typeClass == String.class) {
            try {
                return new ENode(Integer.parseInt(this.getString().trim()), this);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ENodeCastException(AcceleoGenMessages.getString("ENode.AdapterNotFound", new Object[]{"Integer", String.valueOf(this.toString()) + " [" + this.getType() + ']'}));
            }
        }
        if (this.typeClass == Boolean.TYPE) {
            if (this.getBoolean()) {
                return new ENode(1, this);
            }
            return new ENode(0, this);
        }
        if (this.typeClass == Integer.TYPE) {
            return this;
        }
        if (this.typeClass == Double.TYPE) {
            return new ENode(((Double)this.value).intValue(), this);
        }
        return new ENode(0, this);
    }

    private ENode toDouble_() throws ENodeCastException {
        if (this.typeClass == EObject.class) {
            return new ENode(1.0, this);
        }
        if (this.typeClass == ENodeList.class) {
            return new ENode(new Double(this.getList().size()), this);
        }
        if (this.typeClass == String.class) {
            try {
                return new ENode(Double.parseDouble(this.getString().trim()), this);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ENodeCastException(AcceleoGenMessages.getString("ENode.AdapterNotFound", new Object[]{"Double", String.valueOf(this.toString()) + " [" + this.getType() + ']'}));
            }
        }
        if (this.typeClass == Boolean.TYPE) {
            if (this.getBoolean()) {
                return new ENode(1.0, this);
            }
            return new ENode(0.0, this);
        }
        if (this.typeClass == Integer.TYPE) {
            return new ENode(new Double(this.getInt()), this);
        }
        if (this.typeClass == Double.TYPE) {
            return this;
        }
        return new ENode(0.0, this);
    }

    private ENode toNull_() {
        return new ENode(EMPTY, this);
    }

    public EObject getEObject() throws ENodeCastException {
        if (this.isEObject()) {
            return (EObject)this.value;
        }
        throw new ENodeCastException(AcceleoGenMessages.getString("ENode.ENodeCastExceptionMessage", new Object[]{this.type, T_EObject}));
    }

    public ENodeList getList() throws ENodeCastException {
        if (this.isList()) {
            return (ENodeList)this.value;
        }
        throw new ENodeCastException(AcceleoGenMessages.getString("ENode.ENodeCastExceptionMessage", new Object[]{this.type, T_ENodeList}));
    }

    public String getString() throws ENodeCastException {
        if (this.isString()) {
            return (String)this.value;
        }
        throw new ENodeCastException(AcceleoGenMessages.getString("ENode.ENodeCastExceptionMessage", new Object[]{this.type, T_String}));
    }

    public boolean getBoolean() throws ENodeCastException {
        if (this.isBoolean()) {
            return (Boolean)this.value;
        }
        throw new ENodeCastException(AcceleoGenMessages.getString("ENode.ENodeCastExceptionMessage", new Object[]{this.type, T_boolean}));
    }

    public int getInt() throws ENodeCastException {
        if (this.isInt()) {
            return (Integer)this.value;
        }
        throw new ENodeCastException(AcceleoGenMessages.getString("ENode.ENodeCastExceptionMessage", new Object[]{this.type, T_int}));
    }

    public double getDouble() throws ENodeCastException {
        if (this.isDouble()) {
            return (Double)this.value;
        }
        throw new ENodeCastException(AcceleoGenMessages.getString("ENode.ENodeCastExceptionMessage", new Object[]{this.type, T_double}));
    }

    public String asString() {
        if (this.isList()) {
            try {
                ENodeIterator it = this.getList().iterator();
                this.init("", T_String, String.class);
                while (it.hasNext()) {
                    ENode child = it.next();
                    this.append(child);
                }
            }
            catch (ENodeCastException eNodeCastException) {}
        } else if (!this.isString()) {
            String v = this.toString();
            this.init(v, T_String, String.class);
        }
        return (String)this.value;
    }

    public void append(ENode other) {
        if (this.isNull() && !other.isString()) {
            this.init(other.value, other.type, other.typeClass);
            this.log.getAll(other.log, false);
        } else if (other.isList()) {
            try {
                ENodeIterator it = other.getList().iterator();
                while (it.hasNext()) {
                    ENode child = it.next();
                    this.append(child);
                }
            }
            catch (ENodeCastException eNodeCastException) {}
        } else {
            String buffer = other.asString();
            if (other.textModelMapping != null) {
                other.textModelMapping.commit();
            }
            if (other.textTemplateElementMapping != null) {
                other.textTemplateElementMapping.commit();
            }
            this.asString();
            int size = this.size();
            this.value = String.valueOf((String)this.value) + buffer;
            if (this.textModelMapping != null && other.textModelMapping != null) {
                this.textModelMapping.from(other.textModelMapping);
            }
            if (this.textTemplateElementMapping != null && other.textTemplateElementMapping != null) {
                this.textTemplateElementMapping.from(other.textTemplateElementMapping);
            }
            other.log().shiftPosition(size);
            this.log.getAll(other.log, false);
        }
    }

    public void append(String text) {
        this.append(text, -1);
    }

    public void append(String text, int highlightedType) {
        this.asString();
        this.value = String.valueOf(this.value) + text;
        if (this.textModelMapping != null) {
            this.textModelMapping.shift(text.length(), highlightedType);
        }
        if (this.textTemplateElementMapping != null) {
            this.textTemplateElementMapping.shift(text.length(), highlightedType);
        }
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof ENode) {
            try {
                return this.equals((ENode)other);
            }
            catch (ENodeCastException eNodeCastException) {
                return false;
            }
        }
        if (this.value == null && other == null) {
            return true;
        }
        if (this.value == null || other == null) {
            return false;
        }
        return this.value.equals(other);
    }

    public boolean equals(ENode other) throws ENodeCastException {
        if (this.isNull() && other.isNull()) {
            return true;
        }
        if (this.isNull() || other.isNull()) {
            return this.toString().equals(other.toString());
        }
        if (this.type == other.type) {
            return this.value.equals(other.value);
        }
        if (other.isBoolean()) {
            return other.value.equals(this.getAdapterValue(other.getTypeClass()));
        }
        if (this.value.equals(other.getAdapterValue(this.getTypeClass()))) {
            return true;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int size() {
        if (this.isEObject()) {
            return 1;
        }
        if (this.isList()) {
            return ((ENodeList)this.value).size();
        }
        if (this.isString()) {
            return ((String)this.value).length();
        }
        if (this.isBoolean()) {
            return 1;
        }
        if (this.isInt()) {
            return 1;
        }
        if (this.isDouble()) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object other) {
        int result = 0;
        if (other instanceof ENode) {
            result = this.getValue() instanceof Comparable && ((ENode)other).getValue() instanceof Comparable ? ((Comparable)this.getValue()).compareTo(((ENode)other).getValue()) : this.toString().compareTo(other.toString());
        }
        if (result != 0) {
            return result;
        }
        return 1;
    }

    public String toString() {
        if (this.isNull()) {
            return "";
        }
        if (this.isEObject() && !(this.value instanceof EEnumLiteral)) {
            EObject object = (EObject)this.value;
            String buffer = object.toString();
            int iProperties = buffer.indexOf("(");
            if (iProperties > -1) {
                return String.valueOf(ETools.getEClassifierShortPath((EClassifier)object.eClass())) + ' ' + buffer.substring(iProperties);
            }
            return this.value.toString();
        }
        if (this.isDouble()) {
            return NumberFormat.getInstance().format((Double)this.value);
        }
        return this.value.toString();
    }

    public boolean isContainment() {
        return this.containment;
    }

    public void setContainment(boolean containment) {
        this.containment = containment;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean eInstanceof(String name) {
        if (this.getType().equals(name)) {
            return true;
        }
        try {
            return EFactory.eInstanceOf(this.getEObject(), name);
        }
        catch (ENodeCastException eNodeCastException) {
            return false;
        }
    }

    public static ENode createTry(Object value, ENode parent) {
        if (value == null) {
            return new ENode(EMPTY, parent);
        }
        if (value instanceof ENode) {
            ENode node = (ENode)value;
            if (node.containerEObject == null && parent.containerEObject != null) {
                ENode result = new ENode(EMPTY, parent);
                result.append(node);
                return result;
            }
            return node;
        }
        if (value instanceof EObject) {
            if (value instanceof Enumerator) {
                return new ENode(((Enumerator)value).getLiteral(), parent);
            }
            return new ENode((EObject)value, parent);
        }
        if (value instanceof String) {
            return new ENode((String)value, parent);
        }
        if (value instanceof ENodeList) {
            return new ENode((ENodeList)value, parent);
        }
        if (value instanceof Collection) {
            ENodeList result = new ENodeList();
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                ENode element = ENode.createTry(it.next(), parent);
                if (element == null) continue;
                result.add(element);
            }
            return new ENode(result, parent);
        }
        if (value instanceof Object[]) {
            Object[] values;
            ENodeList result = new ENodeList();
            Object[] objectArray = values = (Object[])value;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value2 = objectArray[n2];
                ENode element = ENode.createTry(value2, parent);
                if (element != null) {
                    result.add(element);
                }
                ++n2;
            }
            return new ENode(result, parent);
        }
        if (value instanceof Boolean) {
            return new ENode((Boolean)value, parent);
        }
        if (value instanceof Integer) {
            return new ENode((Integer)value, parent);
        }
        if (value instanceof Short) {
            return new ENode(((Short)value).intValue(), parent);
        }
        if (value instanceof Long) {
            return new ENode(((Long)value).intValue(), parent);
        }
        if (value instanceof Double) {
            return new ENode((Double)value, parent);
        }
        if (value instanceof Float) {
            return new ENode(((Float)value).doubleValue(), parent);
        }
        if (value instanceof Character) {
            return new ENode(String.valueOf(value), parent);
        }
        return new ENode(value.toString(), parent);
    }

    public void stringCall(String name, int begin, int end) {
        if (this.isList()) {
            try {
                ENodeIterator it = this.getList().iterator();
                this.init(new ENodeList(), T_ENodeList, ENodeList.class);
                while (it.hasNext()) {
                    ENode child = it.next();
                    child.stringCall(name, begin, end);
                    this.getList().add(child);
                }
            }
            catch (ENodeCastException eNodeCastException) {}
        } else {
            String text;
            if (!this.isString()) {
                String v = this.toString();
                this.init(v, T_String, String.class);
            }
            if ((text = (String)this.value).length() > 0) {
                if ("trim".equals(name)) {
                    Int2 range = TextSearch.getDefaultSearch().trim(text, 0, text.length());
                    if (range.b() > 0 || range.e() < text.length()) {
                        this.range(range);
                        this.value = this.substring(text, range.b(), range.e());
                    }
                } else if ("substring".equals(name)) {
                    Int2 range = end > -1 ? new Int2(begin, end) : new Int2(begin, text.length());
                    if (range.b() > 0 || range.e() < text.length()) {
                        this.range(range);
                        this.value = this.substring(text, range.b(), range.e());
                    }
                } else if ("toLowerCase".equals(name)) {
                    this.value = text.toLowerCase();
                } else if ("toUpperCase".equals(name)) {
                    this.value = text.toUpperCase();
                } else if ("toU1Case".equals(name)) {
                    this.value = String.valueOf(Character.toUpperCase(text.charAt(0))) + text.substring(1);
                } else if ("toL1Case".equals(name)) {
                    this.value = String.valueOf(Character.toLowerCase(text.charAt(0))) + text.substring(1);
                } else if ("indentSpace".equals(name) || "indentTab".equals(name)) {
                    char c = "indentSpace".equals(name) ? (char)' ' : '\t';
                    StringBuffer buffer = new StringBuffer(text);
                    Int2[] lines = TextSearch.getDefaultSearch().splitPositionsOf(text, new String[]{"\n"}, false);
                    this.indent(lines);
                    int i = lines.length - 1;
                    while (i >= 0) {
                        buffer.insert(lines[i].b(), c);
                        --i;
                    }
                    this.value = buffer.toString();
                } else if (name != null && name.startsWith("internalIndent:")) {
                    String indent = name.substring("internalIndent:".length());
                    StringBuffer buffer = new StringBuffer(text);
                    Int2[] lines = TextSearch.getDefaultSearch().splitPositionsOf(text, new String[]{"\n"}, false);
                    int i = 0;
                    while (i < indent.length()) {
                        this.indent(lines);
                        ++i;
                    }
                    i = lines.length - 1;
                    while (i >= 0) {
                        buffer.insert(lines[i].b(), indent);
                        --i;
                    }
                    this.value = buffer.toString();
                    this.stringCall("substring", indent.length(), -1);
                }
            }
        }
    }

    private void range(Int2 range) {
        if (this.textModelMapping != null) {
            this.textModelMapping.range(range);
        }
        if (this.textTemplateElementMapping != null) {
            this.textTemplateElementMapping.range(range);
        }
        this.log.range(range);
    }

    private String substring(String s, int begin, int end) {
        if (begin < 0 || end < 0 || begin >= s.length() || end <= begin) {
            return "";
        }
        if (end >= s.length()) {
            return s.substring(begin);
        }
        return s.substring(begin, end);
    }

    private void indent(Int2[] lines) {
        if (this.textModelMapping != null) {
            this.textModelMapping.indent(lines);
        }
        if (this.textTemplateElementMapping != null) {
            this.textTemplateElementMapping.indent(lines);
        }
        this.log.indent(lines);
    }

    public ENode copy() {
        if (this.value == null) {
            return new ENode(EMPTY, this);
        }
        if (this.value instanceof EObject) {
            return new ENode((EObject)this.value, this);
        }
        if (this.value instanceof String) {
            return new ENode((String)this.value, this);
        }
        if (this.value instanceof ENodeList) {
            return new ENode((ENodeList)this.value, this);
        }
        if (this.value instanceof Boolean) {
            return new ENode((Boolean)this.value, this);
        }
        if (this.value instanceof Integer) {
            return new ENode((Integer)this.value, this);
        }
        if (this.value instanceof Double) {
            return new ENode((Double)this.value, this);
        }
        return new ENode(this.value.toString(), this);
    }
}

