/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.eval;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.log.AcceleoException;
import org.eclipse.sirius.query.legacy.tools.log.Trace;
import org.eclipse.sirius.query.legacy.tools.plugins.AcceleoModuleProvider;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class ENodeException
extends AcceleoException {
    private static final long serialVersionUID = 1L;
    public static final String RUNTIME_ERROR_MARKER_ID = "org.eclipse.sirius.query.legacy.gen.ui.problem";
    public static final String RUNTIME_ERROR_MARKER_MODEL = "runmodel";
    public static final String RUNTIME_ERROR_MARKER_FRAGMENT = "runfragment";
    protected Int2 pos;
    protected IScript script;
    protected Object object;
    protected Throwable exception;
    private static boolean runtimeMarker = true;
    private static Object disabledTrigger = null;

    public static void disableRuntimeMarkersFor(Object source) {
        if (runtimeMarker && disabledTrigger == null) {
            runtimeMarker = false;
            disabledTrigger = source;
        }
    }

    public static void enableRuntimeMarkersFor(Object source) {
        if (!runtimeMarker && source == disabledTrigger) {
            runtimeMarker = true;
            disabledTrigger = null;
        }
    }

    public ENodeException(String message, Int2 pos, IScript script, Object object, boolean report) {
        this(message, pos, script, object, report, null);
    }

    public ENodeException(String message, Int2 pos, IScript script, Object object, boolean report, Throwable exception) {
        super(message);
        this.pos = pos;
        this.script = script;
        this.object = object;
        this.exception = exception;
        if (report && runtimeMarker) {
            this.getErrorMessage(true);
        }
    }

    @Override
    public String getMessage() {
        return this.getErrorMessage(false);
    }

    private String getErrorMessage(boolean report) {
        String errorMessage = super.getMessage();
        String extendedErrorMessage = new String();
        if (this.script.getFile() != null) {
            String path = this.script.getFile().getAbsolutePath();
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
            if (workspaceFile == null || !workspaceFile.isAccessible()) {
                String pluginId;
                String relativePath = AcceleoModuleProvider.getDefault().getRelativePath(this.script.getFile());
                if (relativePath != null && (pluginId = AcceleoModuleProvider.getDefault().getPluginId(this.script.getFile())) != null) {
                    path = new Path(String.valueOf('/') + pluginId).append(relativePath).toString();
                }
            } else {
                path = workspaceFile.getFullPath().toString();
            }
            Int2[] newLines = TextSearch.getDefaultSearch().allIndexIn(Resources.getFileContent(this.script.getFile()).toString(), "\n", 0, this.pos.b());
            int line = newLines.length + 1;
            int column = this.pos.b();
            if (newLines.length > 0) {
                column -= newLines[newLines.length - 1].e();
            }
            extendedErrorMessage = AcceleoGenMessages.getString("ENodeException.ExtendedErrorMessage.KnownFile", new Object[]{errorMessage, path, Integer.toString(line), Integer.toString(column)});
        } else if (this.pos.b() > 0) {
            extendedErrorMessage = AcceleoGenMessages.getString("ENodeException.ExtendedErrorMessage.UnknownFile", new Object[]{errorMessage, Integer.toString(this.pos.b()), Integer.toString(this.pos.e())});
        }
        String modelURI = "";
        String fragmentURI = "";
        if (this.object != null) {
            Object object = this.object;
            if (object instanceof ENode) {
                if (((ENode)object).isEObject()) {
                    try {
                        object = ((ENode)object).getEObject();
                    }
                    catch (ENodeCastException eNodeCastException) {}
                } else if (((ENode)object).isList()) {
                    extendedErrorMessage = String.valueOf(extendedErrorMessage) + AcceleoGenMessages.getString("ENodeException.ExtendedErrorMessage.NodeFragment", new Object[]{((ENode)object).getType()});
                    object = ((ENode)object).getContainerEObject();
                } else {
                    extendedErrorMessage = String.valueOf(extendedErrorMessage) + AcceleoGenMessages.getString("ENodeException.ExtendedErrorMessage.NodeFragment", new Object[]{((ENode)object).getType()});
                    extendedErrorMessage = String.valueOf(extendedErrorMessage) + " : " + ((ENode)object).toString();
                    object = ((ENode)object).getContainerEObject();
                }
            }
            if (object instanceof EObject) {
                try {
                    fragmentURI = ETools.getURI((EObject)object);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                if (((EObject)object).eResource() != null) {
                    URI uri = ((EObject)object).eResource().getURI();
                    modelURI = uri != null ? uri.path() : "";
                    extendedErrorMessage = String.valueOf(extendedErrorMessage) + AcceleoGenMessages.getString("ENodeException.ExtendedErrorMessage.ObjectFragmentKnownResource", new Object[]{fragmentURI, modelURI});
                } else {
                    extendedErrorMessage = String.valueOf(extendedErrorMessage) + AcceleoGenMessages.getString("ENodeException.ExtendedErrorMessage.ObjectFragmentUnknownResource", new Object[]{fragmentURI, ((EObject)object).eClass().getName(), object.toString()});
                }
            }
        }
        if (this.exception != null) {
            extendedErrorMessage = String.valueOf(extendedErrorMessage) + '\n' + Trace.getStackTrace(this.exception);
        }
        return extendedErrorMessage;
    }
}

