/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.scripts;

import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;

public class ScriptDescriptor {
    protected String type;
    protected String name;
    protected String description;
    protected Int2 fileTemplate;
    protected Int2 postExpression;
    protected Int2 pos;

    public ScriptDescriptor(String type, String name) {
        this(type, name, "", null, null);
    }

    public ScriptDescriptor(String type, String name, String description, Int2 fileTemplate, Int2 postExpression) {
        this.type = type;
        this.name = name;
        this.description = description != null ? description : "";
        this.fileTemplate = fileTemplate;
        this.postExpression = postExpression;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Int2 getFileTemplate() {
        return this.fileTemplate;
    }

    public Int2 getPostExpression() {
        return this.postExpression;
    }

    public boolean equals(Object other) {
        if (other instanceof ScriptDescriptor) {
            return this.type.equals(((ScriptDescriptor)other).type) && this.name.equals(((ScriptDescriptor)other).name);
        }
        return false;
    }

    public int hashCode() {
        StringBuffer key = new StringBuffer();
        key.append(this.type);
        key.append(' ');
        key.append(this.name);
        return key.toString().hashCode();
    }

    public String toString() {
        String type = this.type;
        int dot = type.lastIndexOf(".");
        int n = dot = dot > -1 ? type.substring(0, dot).lastIndexOf(".") : -1;
        if (dot > -1) {
            type = type.substring(dot + 1);
        }
        StringBuffer buffer = new StringBuffer("");
        buffer.append(TemplateConstants.SCRIPT_TYPE);
        buffer.append(TemplateConstants.SCRIPT_PROPERTY_ASSIGN);
        buffer.append(TemplateConstants.LITERAL[0]);
        buffer.append(type);
        buffer.append(TemplateConstants.LITERAL[1]);
        buffer.append(' ');
        buffer.append(TemplateConstants.SCRIPT_NAME);
        buffer.append(TemplateConstants.SCRIPT_PROPERTY_ASSIGN);
        buffer.append(TemplateConstants.LITERAL[0]);
        buffer.append(this.name);
        buffer.append(TemplateConstants.LITERAL[1]);
        if (this.description != null && this.description.length() > 0) {
            buffer.append(' ');
            buffer.append(TemplateConstants.SCRIPT_DESC);
            buffer.append(TemplateConstants.SCRIPT_PROPERTY_ASSIGN);
            buffer.append(TemplateConstants.LITERAL[0]);
            buffer.append(this.description);
            buffer.append(TemplateConstants.LITERAL[1]);
        }
        return buffer.toString();
    }

    public String getOutlineText() {
        StringBuffer buffer = new StringBuffer("");
        String type = this.type;
        int dot = type.lastIndexOf(".");
        int n = dot = dot > -1 ? type.substring(0, dot).lastIndexOf(".") : -1;
        if (dot > -1) {
            type = type.substring(dot + 1);
        }
        buffer.append(type);
        buffer.append(" : ");
        buffer.append(this.name);
        return buffer.toString();
    }

    public Int2 getPos() {
        return this.pos;
    }

    public void setPos(Int2 pos) {
        this.pos = pos;
    }
}

