/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.statements;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.Template;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateElement;
import org.eclipse.sirius.query.legacy.gen.template.TemplateNodeElement;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.eval.log.EvalFailure;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;

public class TemplateIfStatement
extends TemplateNodeElement {
    protected TemplateExpression condition;
    protected Template ifTemplate;
    protected TemplateExpression[] elseIfConditions;
    protected Template[] elseIfTemplates;
    protected Template elseTemplate;

    public TemplateIfStatement(TemplateExpression condition, Template ifTemplate, Template elseTemplate, IScript script) {
        this(condition, ifTemplate, new TemplateExpression[0], new Template[0], elseTemplate, script);
    }

    public TemplateIfStatement(TemplateExpression condition, Template ifTemplate, TemplateExpression[] elseIfConditions, Template[] elseIfTemplates, Template elseTemplate, IScript script) {
        super(script);
        this.condition = condition;
        this.condition.setParent(this);
        this.ifTemplate = ifTemplate;
        this.ifTemplate.setParent(this);
        this.elseIfConditions = elseIfConditions;
        TemplateElement[] templateElementArray = elseIfConditions;
        int n = elseIfConditions.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateExpression elseIfCondition = templateElementArray[n2];
            elseIfCondition.setParent(this);
            ++n2;
        }
        this.elseIfTemplates = elseIfTemplates;
        templateElementArray = elseIfTemplates;
        n = elseIfTemplates.length;
        n2 = 0;
        while (n2 < n) {
            TemplateElement elseIfTemplate = templateElementArray[n2];
            elseIfTemplate.setParent(this);
            ++n2;
        }
        this.elseTemplate = elseTemplate;
        this.elseTemplate.setParent(this);
    }

    public TemplateExpression getCondition() {
        return this.condition;
    }

    public TemplateExpression[] getElseIfConditions() {
        return this.elseIfConditions;
    }

    public Template[] getElseIfTemplates() {
        return this.elseIfTemplates;
    }

    public Template getElseTemplate() {
        return this.elseTemplate;
    }

    public Template getIfTemplate() {
        return this.ifTemplate;
    }

    public String getConditionText(Template template) {
        if (template == this.ifTemplate) {
            return this.condition.toString();
        }
        if (template == this.elseTemplate) {
            return "else";
        }
        int i = 0;
        while (i < this.elseIfTemplates.length && i < this.elseIfConditions.length) {
            if (template == this.elseIfTemplates[i]) {
                return this.elseIfConditions[i].toString();
            }
            ++i;
        }
        return "";
    }

    @Override
    public ENode evaluate(EObject object, LaunchManager mode) throws ENodeException, FactoryException {
        try {
            ENode result = this.evaluateSub(object, mode);
            return result;
        }
        catch (ENodeException e) {
            ENode result = new ENode(ENode.EMPTY, object, this, mode.isSynchronize());
            result.log().addError(new EvalFailure(e.getMessage()));
            return result;
        }
    }

    private ENode evaluateSub(EObject object, LaunchManager mode) throws ENodeException, FactoryException {
        ENode node = new ENode(ENode.EMPTY, object, this, mode.isSynchronize());
        boolean testOK = false;
        ENode test = this.condition.evaluate(new ENode(object, this.condition, mode.isSynchronize()), this.script, mode);
        if (mode.getMode() == 2) {
            node.log().getAll(test.log(), false);
        }
        try {
            testOK = test.getBoolean();
        }
        catch (ENodeCastException eNodeCastException) {
            try {
                Object boolValue = test.getAdapterValue(Boolean.TYPE);
                if (boolValue instanceof Boolean) {
                    testOK = (Boolean)boolValue;
                }
                throw new ENodeException(AcceleoGenMessages.getString("ENodeError.BooleanRequired", new Object[]{test.getType()}), this.condition.getPos(), this.script, object, true);
            }
            catch (ENodeCastException ex) {
                throw new ENodeException(ex.getMessage(), this.condition.getPos(), this.script, object, true);
            }
        }
        if (testOK) {
            node.append(this.ifTemplate.evaluate(object, mode));
        } else {
            int i = 0;
            while (!testOK && i < this.elseIfConditions.length) {
                TemplateExpression elseIfCondition = this.elseIfConditions[i];
                test = elseIfCondition.evaluate(new ENode(object, elseIfCondition, mode.isSynchronize()), this.script, mode);
                if (mode.getMode() == 2) {
                    node.log().getAll(test.log(), false);
                }
                try {
                    testOK = test.getBoolean();
                }
                catch (ENodeCastException eNodeCastException) {
                    try {
                        Object boolValue = test.getAdapterValue(Boolean.TYPE);
                        if (boolValue instanceof Boolean) {
                            testOK = (Boolean)boolValue;
                        }
                        throw new ENodeException(AcceleoGenMessages.getString("ENodeError.BooleanRequired", new Object[]{test.getType()}), elseIfCondition.getPos(), this.script, object, true);
                    }
                    catch (ENodeCastException ex) {
                        throw new ENodeException(ex.getMessage(), elseIfCondition.getPos(), this.script, object, true);
                    }
                }
                if (testOK) {
                    node.append(this.elseIfTemplates[i].evaluate(object, mode));
                }
                ++i;
            }
            if (!testOK) {
                node.append(this.elseTemplate.evaluate(object, mode));
            }
        }
        return node;
    }

    @Override
    public String toString() {
        String optElse = this.elseTemplate.toString();
        if (optElse.length() > 0) {
            optElse = String.valueOf(TemplateConstants.IF_ELSE) + optElse;
        }
        StringBuffer optElseIf = new StringBuffer("");
        int i = 0;
        while (i < this.elseIfConditions.length) {
            optElseIf.append(TemplateConstants.IF_ELSE_IF);
            optElseIf.append(this.elseIfConditions[i].toString());
            optElseIf.append(TemplateConstants.IF_THEN);
            optElseIf.append(this.elseIfTemplates[i].toString());
            ++i;
        }
        return String.valueOf(TemplateConstants.IF_BEGIN) + this.condition.toString() + TemplateConstants.IF_THEN + this.ifTemplate.toString() + optElseIf.toString() + optElse + TemplateConstants.IF_END;
    }

    @Override
    public String getOutlineText() {
        return "if " + this.condition.toString();
    }

    public static TemplateNodeElement fromString(String buffer, Int2 limits, IScript script) throws TemplateSyntaxException {
        Template ifTemplate;
        Template elseTemplate;
        TemplateExpression condition;
        ArrayList<TemplateExpression> elseIfConditions = new ArrayList<TemplateExpression>();
        ArrayList<Template> elseIfTemplates = new ArrayList<Template>();
        Int2 iThen = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.IF_THEN, limits.b(), limits.e(), TemplateConstants.SPEC, TemplateConstants.INHIBS_EXPRESSION);
        if (iThen.b() > -1) {
            int iThenEnd;
            condition = TemplateExpression.fromString(buffer, new Int2(limits.b(), iThen.b()), script);
            Int2 iElse = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.IF_ELSE, iThen.e(), limits.e(), null, TemplateConstants.INHIBS_STATEMENT);
            if (iElse.b() > -1) {
                iThenEnd = iElse.b();
                Int2 elsePos = new Int2(iElse.e(), limits.e());
                elsePos = Template.formatTemplate(buffer, elsePos, 0);
                elseTemplate = Template.read(buffer, elsePos, script);
            } else {
                iThenEnd = limits.e();
                elseTemplate = new Template(script);
            }
            int iElseIfEndMax = iThenEnd;
            Int2 iElseIf = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.IF_ELSE_IF, iThen.e(), iElseIfEndMax, null, TemplateConstants.INHIBS_STATEMENT);
            if (iElseIf.b() > -1) {
                iThenEnd = iElseIf.b();
                while (iElseIf.b() > -1) {
                    Int2 iTestEnd = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.IF_THEN, iElseIf.e(), iElseIfEndMax, TemplateConstants.SPEC, TemplateConstants.INHIBS_EXPRESSION);
                    if (iTestEnd.b() <= -1) {
                        throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingCloseIf"), script, new Int2(iElseIf.e(), iElseIfEndMax));
                    }
                    TemplateExpression elseIfTest = TemplateExpression.fromString(buffer, new Int2(iElseIf.e(), iTestEnd.b()), script);
                    iElseIf = TextSearch.getDefaultSearch().indexIn(buffer, TemplateConstants.IF_ELSE_IF, iTestEnd.e(), iElseIfEndMax, null, TemplateConstants.INHIBS_STATEMENT);
                    Int2 elseIfPos = iElseIf.b() > -1 ? new Int2(iTestEnd.e(), iElseIf.b()) : new Int2(iTestEnd.e(), iElseIfEndMax);
                    elseIfPos = Template.formatTemplate(buffer, elseIfPos, 0);
                    Template elseIfTemplate = Template.read(buffer, elseIfPos, script);
                    elseIfConditions.add(elseIfTest);
                    elseIfTemplates.add(elseIfTemplate);
                }
            }
            Int2 ifPos = new Int2(iThen.e(), iThenEnd);
            ifPos = Template.formatTemplate(buffer, ifPos, 0);
            ifTemplate = Template.read(buffer, ifPos, script);
        } else {
            condition = TemplateExpression.fromString(buffer, new Int2(limits.b(), limits.e()), script);
            ifTemplate = new Template(script);
            elseTemplate = new Template(script);
        }
        TemplateIfStatement element = new TemplateIfStatement(condition, ifTemplate, elseIfConditions.toArray(new TemplateExpression[elseIfConditions.size()]), elseIfTemplates.toArray(new Template[elseIfTemplates.size()]), elseTemplate, script);
        element.setPos(limits);
        return element;
    }
}

