/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaNavigatorContentProvider;
import org.polarsys.capella.core.ui.search.CapellaSearchSettings;
import org.polarsys.capella.core.ui.search.match.LineSearchMatchChild;
import org.polarsys.capella.core.ui.search.match.ListElementSearchMatchChild;
import org.polarsys.capella.core.ui.search.match.SearchMatch;
import org.polarsys.capella.core.ui.search.result.CapellaSearchResult;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForAttributeItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForClassItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForNoteItem;

public class CapellaSearchQuery
implements ISearchQuery {
    private final CapellaSearchResult capellaSearchResult = new CapellaSearchResult(this);
    private final CapellaSearchSettings capellaSearchSettings;
    private final ITreeContentProvider contentProvider = new CapellaNavigatorContentProvider(){

        public Object[] getChildren(Object element) {
            DRepresentation representation;
            if (element instanceof DRepresentationDescriptor && ((DRepresentationDescriptor)element).isLoadedRepresentation() && (representation = ((DRepresentationDescriptor)element).getRepresentation()) instanceof DDiagram) {
                ArrayList<Shape> notes = new ArrayList<Shape>();
                DDiagramGraphicalQuery query = new DDiagramGraphicalQuery((DDiagram)representation);
                Option gmfDiagram = query.getAssociatedGMFDiagram();
                if (gmfDiagram.some()) {
                    for (Object child : ((Diagram)gmfDiagram.get()).getChildren()) {
                        if (!(child instanceof Shape) || !ViewType.NOTE.equals(((Shape)child).getType())) continue;
                        notes.add((Shape)child);
                    }
                }
                return notes.toArray();
            }
            return super.getChildren(element);
        }
    };

    public CapellaSearchQuery(CapellaSearchSettings capellaSearchSettings) {
        this.capellaSearchSettings = capellaSearchSettings;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.capellaSearchResult.removeAll();
        try {
            Pattern pattern = this.capellaSearchSettings.createPattern();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Set<Object> selectedObjects = this.capellaSearchSettings.getObjectsToSearch();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)selectedObjects.size());
            subMonitor.setTaskName(String.format("Searching for pattern '%s'...", this.capellaSearchSettings.getTextPattern()));
            for (Object selectedObj : selectedObjects) {
                IProject project = null;
                if (selectedObj instanceof IProject) {
                    subMonitor.subTask(String.format("Scanning elements in the project: %s", ((IProject)selectedObj).getName()));
                    project = workspaceRoot.getProject(((IProject)selectedObj).getName());
                } else if (selectedObj instanceof EObject) {
                    project = PreferencesHelper.getProject((EObject)((EObject)selectedObj));
                }
                if (project == null) continue;
                this.search(pattern, selectedObj, project);
                subMonitor.split(1);
            }
            return Status.OK_STATUS;
        }
        catch (PatternSyntaxException e) {
            String message = String.format("The search pattern '%s' is not validated because: %s", e.getPattern(), e.getDescription());
            return new Status(4, "org.polarsys.capella.core.ui.search", message);
        }
        catch (Exception e) {
            String message = e.getMessage();
            return new Status(4, "org.polarsys.capella.core.ui.search", message);
        }
    }

    private void search(Pattern pattern, Object element, IProject project) {
        if (element instanceof EObject) {
            EObject eObj = (EObject)element;
            Set<Object> searchClassItems = this.capellaSearchSettings.getSearchClassItems();
            for (Object searchClassItem : searchClassItems) {
                if (!(searchClassItem instanceof SearchForClassItem) || !((SearchForClassItem)searchClassItem).covers(eObj)) continue;
                if (searchClassItem instanceof SearchForNoteItem) {
                    this.searchForAttribute(pattern, project, eObj, (SearchForNoteItem)searchClassItem);
                    continue;
                }
                Set<Object> searchAttributeItems = this.capellaSearchSettings.getSearchAttributeItems();
                for (Object searchAttributeItem : searchAttributeItems) {
                    if (!(searchAttributeItem instanceof SearchForAttributeItem)) continue;
                    this.searchForAttribute(pattern, project, eObj, (SearchForAttributeItem)searchAttributeItem);
                }
            }
        }
        Object[] children = this.contentProvider.getChildren(element);
        int i = 0;
        while (i < children.length) {
            this.search(pattern, children[i], project);
            ++i;
        }
    }

    protected void searchForAttribute(Pattern pattern, IProject project, EObject inputObject, SearchForAttributeItem attributeItem) {
        Object searchAttribute = attributeItem.getAttributeFor(inputObject);
        if (searchAttribute != null) {
            Object searchData = attributeItem.getRelevantSearchData(inputObject);
            if (searchData instanceof String) {
                String searchText = (String)searchData;
                String[] searchTextLines = searchText.split("\n");
                if (searchTextLines.length == 1) {
                    if (this.isMatchOccurrences(pattern, searchText)) {
                        SearchMatch result = new SearchMatch(inputObject, searchText, project, searchAttribute);
                        this.capellaSearchResult.addMatch(result);
                        this.capellaSearchResult.getTreeData().addElement((Object)inputObject);
                    }
                } else {
                    SearchMatch parentSearchMatch = new SearchMatch(inputObject, null, project, searchAttribute);
                    boolean matched = false;
                    int number = 0;
                    while (number < searchTextLines.length) {
                        String searchTextLine = searchTextLines[number];
                        if (this.isMatchOccurrences(pattern, searchTextLine)) {
                            LineSearchMatchChild childSearchMatch = new LineSearchMatchChild(inputObject, searchTextLine, project, parentSearchMatch, number);
                            parentSearchMatch.getChildren().add(childSearchMatch);
                            this.capellaSearchResult.addMatch(childSearchMatch);
                            matched = true;
                        }
                        ++number;
                    }
                    if (matched) {
                        this.capellaSearchResult.addMatch(parentSearchMatch);
                        this.capellaSearchResult.getTreeData().addElement((Object)inputObject);
                    }
                }
            } else if (searchData instanceof List) {
                List searchDataList = (List)searchData;
                SearchMatch parentSearchMatch = new SearchMatch(inputObject, null, project, searchAttribute);
                boolean matched = false;
                int index = 0;
                while (index < searchDataList.size()) {
                    String searchText;
                    Object searchElement = searchDataList.get(index);
                    if (searchElement instanceof String && this.isMatchOccurrences(pattern, searchText = (String)searchDataList.get(index))) {
                        ListElementSearchMatchChild childSearchMatch = new ListElementSearchMatchChild(inputObject, searchText, project, parentSearchMatch, index);
                        parentSearchMatch.getChildren().add(childSearchMatch);
                        this.capellaSearchResult.addMatch(childSearchMatch);
                        matched = true;
                    }
                    ++index;
                }
                if (matched) {
                    this.capellaSearchResult.addMatch(parentSearchMatch);
                    this.capellaSearchResult.getTreeData().addElement((Object)inputObject);
                }
            }
        }
    }

    protected void searchForAttribute(Pattern pattern, IProject project, EObject eObj, SearchForNoteItem searchNoteItem) {
        Object searchData = searchNoteItem.getRelevantSearchData(eObj);
        if (searchData instanceof String) {
            String textToSearch = (String)searchData;
            EAttribute shapeDescriptionAttribute = searchNoteItem.getContentAttribute();
            if (this.isMatchOccurrences(pattern, textToSearch)) {
                SearchMatch result = new SearchMatch(eObj, textToSearch, project, shapeDescriptionAttribute);
                this.capellaSearchResult.addMatch(result);
                this.capellaSearchResult.getTreeData().addElement((Object)eObj);
            }
        }
    }

    private boolean isMatchOccurrences(Pattern pattern, String text) {
        if (text != null && !text.isEmpty()) {
            Matcher matcher = pattern.matcher(text);
            try {
                if (matcher.find()) {
                    return true;
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return false;
    }

    public String getLabel() {
        return this.capellaSearchSettings.getTextPattern();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public CapellaSearchResult getSearchResult() {
        return this.capellaSearchResult;
    }

    public CapellaSearchSettings getCapellaSearchSettings() {
        return this.capellaSearchSettings;
    }
}

