/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.searchfor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.dialogs.PatternFilter;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.CapellaPatternFilter;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.ui.search.CapellaSearchPage;
import org.polarsys.capella.core.ui.search.CapellaSearchSettings;
import org.polarsys.capella.core.ui.search.searchfor.AbstractCapellaSearchForContainerArea;
import org.polarsys.capella.core.ui.search.searchfor.AbstractSearchForContentProvider;
import org.polarsys.capella.core.ui.search.searchfor.AttributeContentProvider;
import org.polarsys.capella.core.ui.search.searchfor.SearchForItemCache;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForAttributeItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForItem;

public class CapellaRightSearchForContainerArea
extends AbstractCapellaSearchForContainerArea {
    protected AbstractSearchForContentProvider partictipantsItemProvider;
    private Map<EAttribute, Integer> topAttributes = new HashMap<EAttribute, Integer>();

    public CapellaRightSearchForContainerArea(Group parent, AbstractCapellaSearchForContainerArea leftArea, CapellaSearchPage searchPage) {
        super(parent, leftArea, searchPage);
        this.topAttributes.put(ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, 0);
        this.topAttributes.put(CapellacorePackage.Literals.CAPELLA_ELEMENT__SUMMARY, 1);
        this.topAttributes.put(CapellacorePackage.Literals.CAPELLA_ELEMENT__DESCRIPTION, 2);
        this.topAttributes.put(DescriptionPackage.Literals.DOCUMENTED_ELEMENT__DOCUMENTATION, 3);
    }

    @Override
    protected AttributeContentProvider getSearchForContentProvider() {
        if (this.partictipantsItemProvider == null) {
            this.partictipantsItemProvider = new AttributeContentProvider(this.otherSideArea);
        }
        return (AttributeContentProvider)this.partictipantsItemProvider;
    }

    @Override
    protected PatternFilter createPatternFilter() {
        return new CapellaPatternFilter();
    }

    @Override
    public void applySearchSettings(CapellaSearchSettings settings) {
        HashSet<Object> searchAttributeItems = new HashSet<Object>(settings.getSearchAttributeItems());
        super.applySearchSettings(searchAttributeItems);
    }

    @Override
    public void updateSearchSettings() {
        this.searchPage.getCapellaSearchSettings().setSearchAttributeItems(this.getCheckedElements());
    }

    @Override
    protected void createContentArea() {
        super.createContentArea();
        this.filteredTree.getViewer().setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof SearchForAttributeItem && e2 instanceof SearchForAttributeItem) {
                    SearchForAttributeItem item1 = (SearchForAttributeItem)e1;
                    SearchForAttributeItem item2 = (SearchForAttributeItem)e2;
                    Optional<EAttribute> item1TopAttribute = CapellaRightSearchForContainerArea.this.topAttributes.keySet().stream().filter(item1::represent).findAny();
                    Optional<EAttribute> item2TopAttribute = CapellaRightSearchForContainerArea.this.topAttributes.keySet().stream().filter(item2::represent).findAny();
                    if (item1TopAttribute.isPresent() && item2TopAttribute.isPresent()) {
                        return CapellaRightSearchForContainerArea.this.topAttributes.get(item1TopAttribute.get()) < CapellaRightSearchForContainerArea.this.topAttributes.get(item2TopAttribute.get()) ? -1 : 1;
                    }
                    if (item1TopAttribute.isPresent()) {
                        return -1;
                    }
                    if (item2TopAttribute.isPresent()) {
                        return 1;
                    }
                    return ((SearchForItem)e1).getText().compareTo(((SearchForItem)e2).getText());
                }
                return 0;
            }
        });
    }

    @Override
    protected SelectionListener getRestoreDefaultsSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CapellaRightSearchForContainerArea.this.applyDefaultSearchSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
    }

    @Override
    public void applyDefaultSearchSettings() {
        Set topAttributeItems = SearchForItemCache.getInstance().getAttributeItems().stream().filter(SearchForAttributeItem.class::isInstance).map(SearchForAttributeItem.class::cast).filter(item -> this.topAttributes.keySet().stream().anyMatch(item::represent)).collect(Collectors.toSet());
        this.filteredTree.getCheckboxTreeViewer().setCheckedElements(topAttributeItems.toArray());
        this.cleanCheckedElements();
        topAttributeItems.stream().forEach(item -> this.updateCheckedElements(item, true));
        this.updateSearchSettings();
    }
}

