/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.datavalue.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.information.datavalue.properties.Messages;
import org.polarsys.capella.core.data.information.datavalue.properties.sections.DataValueSection;
import org.polarsys.capella.core.ui.properties.controllers.ISimpleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.controllers.SimpleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.SimpleSemanticField;

public abstract class DataValueReferenceSection
extends DataValueSection {
    protected SimpleSemanticField _referencedValueField;
    protected SimpleSemanticField _referencedPropertyField;

    @Override
    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createContents(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        this._referencedValueField = new SimpleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("DataValueReference.ReferencedValue.Label"), this.getWidgetFactory(), (ISimpleSemanticFieldController)new SimpleSemanticFieldController()){

            protected void handleOpenButtonClicked(Button button) {
                super.handleOpenButtonClicked(button);
                this.executeCommand((ICommand)DataValueReferenceSection.this.updateType(this.semanticElement, this.semanticFeature));
                DataValueReferenceSection.this.refresh();
            }

            protected void handleDeleteButtonClicked() {
                super.handleDeleteButtonClicked();
                this.executeCommand((ICommand)DataValueReferenceSection.this.removeType(this.semanticElement));
                DataValueReferenceSection.this.refresh();
            }
        };
        this._referencedValueField.setDisplayedInWizard(displayedInWizard);
        this._referencedPropertyField = new SimpleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("DataValueReference.ReferencedProperty.Label"), this.getWidgetFactory(), (ISimpleSemanticFieldController)new SimpleSemanticFieldController()){

            protected void handleOpenButtonClicked(Button button) {
                super.handleOpenButtonClicked(button);
                this.executeCommand((ICommand)DataValueReferenceSection.this.updateType(this.semanticElement, this.semanticFeature));
                DataValueReferenceSection.this.refresh();
            }

            protected void handleDeleteButtonClicked() {
                super.handleDeleteButtonClicked();
                this.executeCommand((ICommand)DataValueReferenceSection.this.removeType(this.semanticElement));
                DataValueReferenceSection.this.refresh();
            }
        };
        this._referencedPropertyField.setDisplayedInWizard(displayedInWizard);
    }

    protected AbstractReadWriteCommand updateType(final EObject semanticElement, final EStructuralFeature semanticFeature) {
        return new AbstractReadWriteCommand(){

            public void run() {
                EObject obj = (EObject)semanticElement.eGet(semanticFeature);
                if (obj instanceof AbstractTypedElement) {
                    semanticElement.eSet((EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractTypedElement_AbstractType(), (Object)((AbstractTypedElement)obj).getAbstractType());
                }
            }

            public String getName() {
                return "Edit " + semanticElement.eGet((EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name());
            }
        };
    }

    protected AbstractReadWriteCommand removeType(final EObject semanticElement) {
        return new AbstractReadWriteCommand(){

            public void run() {
                semanticElement.eSet((EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractTypedElement_AbstractType(), null);
            }

            public String getName() {
                return "Edit " + semanticElement.eGet((EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name());
            }
        };
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this._referencedPropertyField);
        fields.add((AbstractSemanticField)this._referencedValueField);
        return fields;
    }
}

