/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.studio.product;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.BasicSplashHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.polarsys.capella.core.platform.sirius.ui.perspective.CapellaSplashHandler;
import org.polarsys.kitalpha.ad.services.ToolIntegrationHelper;

public class CapellaStudioSplashHandler
extends BasicSplashHandler {
    private static final String NOT_APPLICABLE = "n/a";
    private static final String FOREGROUND_COLOR_HTML = "262057";

    public void init(Shell splash) {
        Bundle capellaPerspectiveBundle;
        Bundle definingBundle;
        int foregroundColorInteger;
        super.init(splash);
        String progressRectString = null;
        String messageRectString = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRectString = product.getProperty("startupProgressRect");
            messageRectString = product.getProperty("startupMessageRect");
        }
        Rectangle progressRect = StringConverter.asRectangle((String)progressRectString, (Rectangle)new Rectangle(1, 10, 452, 15));
        this.setProgressRect(progressRect);
        Rectangle messageRect = StringConverter.asRectangle((String)messageRectString, (Rectangle)new Rectangle(10, 35, 300, 25));
        this.setMessageRect(messageRect);
        try {
            foregroundColorInteger = Integer.parseInt(FOREGROUND_COLOR_HTML, 16);
        }
        catch (Exception exception) {
            foregroundColorInteger = 7498662;
        }
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        Version studioVersion = null;
        if (product != null && (definingBundle = product.getDefiningBundle()) != null) {
            studioVersion = definingBundle.getVersion();
        }
        String capellaVersion = NOT_APPLICABLE;
        String kitalphaVersion = NOT_APPLICABLE;
        Bundle kitalphaAdServicesBundle = FrameworkUtil.getBundle(ToolIntegrationHelper.class);
        if (kitalphaAdServicesBundle != null) {
            String kitalphaAdServicesBundleVersion = kitalphaAdServicesBundle.getVersion().toString();
            kitalphaVersion = this.trunkQualifier(kitalphaAdServicesBundleVersion);
        }
        if ((capellaPerspectiveBundle = FrameworkUtil.getBundle(CapellaSplashHandler.class)) != null) {
            String capellaPerspectiveBundleVersion = capellaPerspectiveBundle.getVersion().toString();
            capellaVersion = this.trunkQualifier(capellaPerspectiveBundleVersion);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(studioVersion != null ? Integer.valueOf(studioVersion.getMajor()) : NOT_APPLICABLE).append('.');
        builder.append(studioVersion != null ? Integer.valueOf(studioVersion.getMinor()) : NOT_APPLICABLE).append('.');
        builder.append(studioVersion != null ? Integer.valueOf(studioVersion.getMicro()) : NOT_APPLICABLE).append('.');
        builder.append(studioVersion != null ? studioVersion.getQualifier() : NOT_APPLICABLE);
        String fCapellaStudioVersion = "Version " + builder.toString();
        String fCapellaVersion = "Capella  " + capellaVersion;
        String fKitalphaVersion = "Kitalpha " + kitalphaVersion;
        Font font = new Font((Device)this.getContent().getDisplay(), new FontData("Arial", 11, 1));
        Label versionLabel = new Label(this.getContent(), 131072);
        versionLabel.setForeground(this.getForeground());
        versionLabel.setFont(font);
        versionLabel.setBounds(220, 250, 210, 20);
        versionLabel.setText(fCapellaStudioVersion);
        Label capellaVersionLabel = new Label(this.getContent(), 16384);
        capellaVersionLabel.setForeground(this.getForeground());
        capellaVersionLabel.setFont(font);
        capellaVersionLabel.setBounds(20, 250, 100, 20);
        capellaVersionLabel.setText(fCapellaVersion);
        Label kitalphaVersionLabel = new Label(this.getContent(), 16384);
        kitalphaVersionLabel.setForeground(this.getForeground());
        kitalphaVersionLabel.setFont(font);
        kitalphaVersionLabel.setBounds(20, 270, 100, 20);
        kitalphaVersionLabel.setText(fKitalphaVersion);
    }

    private String trunkQualifier(String version) {
        int index = version.lastIndexOf(46);
        if (index < 0) {
            return version;
        }
        return version.substring(0, index);
    }
}

