/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.PreferencesUIMessages;
import org.polarsys.capella.core.commands.preferences.model.AbstractCategoryTreeNode;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferences;
import org.polarsys.capella.core.commands.preferences.model.CategoryPreferencesManager;
import org.polarsys.capella.core.commands.preferences.model.ICategoryTreeNode;
import org.polarsys.capella.core.commands.preferences.model.IItemNode;
import org.polarsys.capella.core.commands.preferences.model.ItemNode;
import org.polarsys.capella.core.commands.preferences.service.IItemDescriptor;
import org.polarsys.capella.core.commands.preferences.service.IItemFilter;
import org.polarsys.capella.core.commands.preferences.service.PreferencesItemsRegistry;

public class CategoryTreeNode
extends AbstractCategoryTreeNode {
    private boolean grayed;
    private boolean checked;
    private ICategoryTreeNode delegate;
    private List<IItemNode> items;

    private CategoryTreeNode(CheckboxTreeViewer tree, CategoryPreferences category, ICategoryTreeNode parent, IItemFilter filter) {
        super(tree, category, parent, filter);
    }

    public static ICategoryTreeNode createRoot(CheckboxTreeViewer tree, final IItemFilter filter) {
        IItemFilter registeredOnly = new IItemFilter(){

            @Override
            public boolean accept(IItemDescriptor constraint, Object target) {
                if (PreferencesItemsRegistry.getInstance().getDescriptor(constraint.getId()) == constraint) {
                    return filter.accept(constraint, target);
                }
                return true;
            }
        };
        RootNode result = new RootNode(tree, registeredOnly);
        result.revertFromPreferences();
        return result;
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public boolean isGrayed() {
        return this.grayed;
    }

    @Override
    protected List<ICategoryTreeNode> createChildren() {
        ArrayList<ICategoryTreeNode> result;
        CategoryPreferences category = this.getCategory();
        SortedSet<CategoryPreferences> categoryChildren = category.getChildren();
        if (!categoryChildren.isEmpty() && !CategoryTreeNode.getItems(category, this.getFilter()).isEmpty()) {
            result = new ArrayList(categoryChildren.size() + 1);
            this.delegate = new DelegateNode(this.getTree(), category, this, this.getFilter());
            result.add(this.delegate);
        } else {
            result = new ArrayList<ICategoryTreeNode>(categoryChildren.size());
        }
        for (CategoryPreferences next : categoryChildren) {
            if (this.isRecursivelyEmpty(next)) continue;
            result.add(new CategoryTreeNode(this.getTree(), next, this, this.getFilter()));
        }
        return result;
    }

    @Override
    public void checkStateChanged(CheckStateChangedEvent event) {
        boolean newState = event.getChecked();
        if (this.isGrayed()) {
            this.internalSetChecked(true);
        } else {
            this.internalSetChecked(newState);
        }
    }

    protected void internalSetChecked(boolean newState) {
        this.checked = !this.hasDelegate() && this.getCategory().isMandatory() ? true : newState;
        this.grayed = false;
        this.propagateToItems(newState);
        this.propagateDown(newState);
        this.updateTree();
    }

    private void propagateToItems(boolean newChecked) {
        if (!this.hasDelegate()) {
            for (IItemNode next : this.getItems()) {
                next.setChecked(newChecked);
            }
        }
    }

    private void updateTree() {
        CheckboxTreeViewer tree = this.getTree();
        if (tree.getChecked((Object)this) != this.isChecked()) {
            tree.setChecked((Object)this, this.isChecked());
        }
        if (tree.getGrayed((Object)this) != this.isGrayed()) {
            tree.setGrayed((Object)this, this.isGrayed());
        }
        this.updateParent();
    }

    private void updateParent() {
        if (this.getParent() != null) {
            this.getParent().updateCheckState(this);
        }
    }

    @Override
    public void updateCheckState(ICategoryTreeNode child) {
        if (child.isGrayed()) {
            this.grayed = true;
            this.checked = true;
            this.updateTree();
        } else {
            boolean newValue = child.isChecked();
            ICategoryTreeNode[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].isGrayed() || children[i].isChecked() != newValue) {
                    this.grayed = true;
                    this.checked = true;
                    this.updateTree();
                    return;
                }
                ++i;
            }
            this.grayed = false;
            this.checked = newValue;
            this.updateTree();
        }
    }

    @Override
    public void updateCheckState(IItemNode constraint) {
        boolean newValue;
        boolean newChecked = newValue = constraint.isChecked();
        boolean newGrayed = false;
        for (IItemNode next : this.getItems()) {
            if (next == constraint || next.isChecked() == newValue) continue;
            newGrayed = true;
            newChecked = true;
            break;
        }
        this.checked = newChecked;
        this.grayed = newGrayed;
        this.updateTree();
    }

    private void propagateDown(boolean checkedState) {
        ICategoryTreeNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            ((CategoryTreeNode)children[i]).internalSetChecked(checkedState);
            ++i;
        }
    }

    @Override
    public void applyToPreferences() {
        if (!this.hasDelegate()) {
            for (IItemNode next : this.getItems()) {
                next.applyToPreferences();
            }
        }
        super.applyToPreferences();
    }

    @Override
    public void revertFromPreferences() {
        if (!this.hasDelegate()) {
            IItemNode node2 = null;
            for (IItemNode node2 : this.getItems()) {
                node2.revertFromPreferences();
            }
            if (node2 != null) {
                this.updateCheckState(node2);
            }
        }
        super.revertFromPreferences();
    }

    @Override
    public void restoreDefaults() {
        if (!this.hasDelegate()) {
            IItemNode node2 = null;
            for (IItemNode node2 : this.getItems()) {
                node2.restoreDefaults();
            }
            if (node2 != null) {
                this.updateCheckState(node2);
            }
        }
        super.restoreDefaults();
    }

    @Override
    public CategoryPreferences getCategory() {
        if (this.hasDelegate()) {
            return null;
        }
        return super.getCategory();
    }

    @Override
    public List<IItemNode> getItems() {
        if (this.hasDelegate()) {
            this.items = Collections.emptyList();
        } else if (this.items == null) {
            Set<IItemDescriptor> descriptors = CategoryTreeNode.getItems(this.getCategory(), this.getFilter());
            this.items = new ArrayList<IItemNode>(descriptors.size());
            for (IItemDescriptor next : descriptors) {
                IItemNode node = ItemNode.getInstance(next);
                node.addCategory(this);
                this.items.add(node);
            }
        }
        return this.items;
    }

    @Override
    public IItemNode[] getSelectedItems() {
        ArrayList<IItemNode> result = new ArrayList<IItemNode>(this.getItems().size());
        for (IItemNode next : this.getItems()) {
            if (!next.isChecked()) continue;
            result.add(next);
        }
        return result.toArray(new IItemNode[result.size()]);
    }

    private boolean hasDelegate() {
        return this.delegate != null;
    }

    @Override
    public String toString() {
        if (this.getCategory() == null && this.hasDelegate()) {
            return this.delegate.getCategory().getName();
        }
        return super.toString();
    }

    private static class DelegateNode
    extends CategoryTreeNode {
        DelegateNode(CheckboxTreeViewer tree, CategoryPreferences category, ICategoryTreeNode parent, IItemFilter filter) {
            super(tree, category, parent, filter);
        }

        @Override
        protected List<ICategoryTreeNode> createChildren() {
            return Collections.emptyList();
        }

        @Override
        public String toString() {
            String result = super.toString();
            StringBuffer buf = new StringBuffer(result.length() + 2);
            buf.append(NLS.bind((String)PreferencesUIMessages.prefs_delegate_name, (Object[])new Object[]{result}));
            result = buf.toString();
            return result;
        }
    }

    private static class RootNode
    extends AbstractCategoryTreeNode {
        RootNode(CheckboxTreeViewer tree, IItemFilter filter) {
            super(tree, null, null, filter);
        }

        @Override
        protected List<ICategoryTreeNode> createChildren() {
            CategoryPreferencesManager instance = CategoryPreferencesManager.getInstance();
            instance.initDefaultCategory();
            SortedSet<CategoryPreferences> topLevel = instance.getFirstCategoriesLevel();
            ArrayList<ICategoryTreeNode> result = new ArrayList<ICategoryTreeNode>(topLevel.size());
            for (CategoryPreferences next : topLevel) {
                if (this.isRecursivelyEmpty(next)) continue;
                CategoryTreeNode categoryTreeNode = new CategoryTreeNode(this.getTree(), next, this, this.getFilter());
                result.add(categoryTreeNode);
            }
            return result;
        }

        @Override
        public boolean isChecked() {
            return false;
        }

        @Override
        public boolean isGrayed() {
            return false;
        }

        @Override
        public void checkStateChanged(CheckStateChangedEvent event) {
        }

        @Override
        public void updateCheckState(ICategoryTreeNode child) {
        }

        @Override
        public void updateCheckState(IItemNode constraint) {
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public List<IItemNode> getItems() {
            return Collections.emptyList();
        }
    }
}

