/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.preferences.transferer;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.polarsys.capella.core.preferences.transferer.WizardPreferencesTransfererExportPage;

public class PreferenceProjectSelectionDialog
extends CheckedTreeSelectionDialog {
    private WizardPreferencesTransfererExportPage parentWizard;
    private final String SUFFIX_EPF_FILE_NAME = "_preferences.epf";

    public PreferenceProjectSelectionDialog(WizardPreferencesTransfererExportPage wizardPreferencesTransfererExportPage, Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.parentWizard = wizardPreferencesTransfererExportPage;
    }

    protected void computeResult() {
        super.computeResult();
        this.setResult(Arrays.asList(this.getTreeViewer().getCheckedElements()));
        IProject project = (IProject)this.getFirstResult();
        IFile file = null;
        try {
            if (project != null) {
                IResource[] members;
                IResource[] iResourceArray = members = project.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource = iResourceArray[n2];
                    if (iResource instanceof IFolder) {
                        IFolder settingFolder = (IFolder)iResource;
                        settingFolder.getLocation().append(String.valueOf(project.getName()) + "_preferences.epf");
                        file = settingFolder.getFile(String.valueOf(project.getName()) + "_preferences.epf");
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
        if (this.parentWizard != null) {
            StringBuffer location = new StringBuffer();
            location.append(project.getLocation().toOSString());
            location.append("/" + project.getName() + "_preferences.epf");
            this.parentWizard.addDestinationItem(location.toString());
        }
        this.close();
    }

    public void addFilter(ViewerFilter filter) {
        super.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                try {
                    return element instanceof IProject && ((IProject)element).getNature("org.polarsys.capella.core.preferences.project.nature.configNature") != null;
                }
                catch (CoreException exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
        });
    }
}

