/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadOnlyCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.helpers.query.IQuery;
import org.polarsys.kitalpha.emde.extension.ModelExtensionHelper;
import org.polarsys.kitalpha.emde.extension.ModelExtensionManager;

public class QueryAdapter {
    private static QueryAdapter instance = null;

    private QueryAdapter() {
    }

    public static QueryAdapter getInstance() {
        if (instance == null) {
            instance = new QueryAdapter();
        }
        return instance;
    }

    public List<Object> compute(Object currentElement, Object query) {
        ExecutionManager executionManager;
        List<Object> result = Collections.emptyList();
        if (currentElement instanceof EObject && (executionManager = TransactionHelper.getExecutionManager((EObject)((EObject)currentElement))) != null) {
            QueryComputeCommand queryComputeCommand = new QueryComputeCommand(currentElement, query);
            executionManager.execute((ICommand)queryComputeCommand);
            result = new ArrayList<Object>((List)queryComputeCommand.getResult());
            Iterator<Object> iterator = result.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
            }
        }
        return result;
    }

    protected class QueryComputeCommand
    extends AbstractReadOnlyCommand {
        protected List<Object> internalResult = new ArrayList<Object>(0);
        protected Object currentElement = null;
        protected Object query = null;

        public QueryComputeCommand(Object currentElement, Object query) {
            this.currentElement = currentElement;
            this.query = query;
        }

        public void run() {
            if (this.query instanceof IQuery) {
                ModelExtensionManager mgr = null;
                if (this.currentElement instanceof EObject) {
                    mgr = ModelExtensionHelper.getInstance((EObject)((EObject)this.currentElement));
                }
                for (Object o : ((IQuery)this.query).compute(this.currentElement)) {
                    if (mgr != null && mgr.isExtensionModelDisabled(o)) continue;
                    this.internalResult.add(o);
                }
                this.setResult(this.internalResult);
            }
        }
    }
}

