/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.generic.impl.policies;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.config.IConfigurablePolicy;
import org.eclipse.emf.diffmerge.generic.impl.policies.CachingMatchPolicy;

public class ConfigurableMatchPolicy<E>
extends CachingMatchPolicy<E>
implements IConfigurablePolicy {
    private boolean _keepMatchIDs = false;
    private boolean _useCache = false;
    protected final Set<IConfigurablePolicy.IConfigurationChangedListener> _listeners = new LinkedHashSet<IConfigurablePolicy.IConfigurationChangedListener>();

    public ConfigurableMatchPolicy() {
    }

    public ConfigurableMatchPolicy(ConfigurableMatchPolicy<E> policy_p) {
        this();
        this.update(policy_p);
    }

    @Override
    public void addConfigurationChangedListener(IConfigurablePolicy.IConfigurationChangedListener listener_p) {
        this._listeners.add(listener_p);
    }

    protected void fireConfigurationChanged(Object property_p) {
        for (IConfigurablePolicy.IConfigurationChangedListener listener : this._listeners) {
            listener.configurationChanged(this, property_p);
        }
    }

    @Override
    public boolean keepMatchIDs() {
        return this._keepMatchIDs;
    }

    @Override
    public void removeConfigurationChangedListener(IConfigurablePolicy.IConfigurationChangedListener listener_p) {
        this._listeners.remove(listener_p);
    }

    public void setKeepMatchIDs(boolean keep_p) {
        this._keepMatchIDs = keep_p;
        this.fireConfigurationChanged(null);
    }

    public void setUseCache(boolean useCache_p) {
        this._useCache = useCache_p;
        this.fireConfigurationChanged(null);
    }

    @Override
    public boolean update(IConfigurablePolicy policy_p) {
        boolean result = false;
        if (policy_p instanceof IMatchPolicy) {
            this.setKeepMatchIDs(((IMatchPolicy)((Object)policy_p)).keepMatchIDs());
            if (policy_p instanceof ConfigurableMatchPolicy) {
                ConfigurableMatchPolicy policy = (ConfigurableMatchPolicy)policy_p;
                this.setUseCache(policy.useCache());
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean useCache() {
        return this._useCache;
    }

    @Override
    public ConfigurableMatchPolicy copy() {
        return new ConfigurableMatchPolicy<E>(this);
    }
}

