/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.ui.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.flexibility.properties.loader.PropertiesLoader;
import org.polarsys.capella.common.flexibility.properties.property.PropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.loader.RenderersLoader;
import org.polarsys.capella.common.flexibility.wizards.renderer.RendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderers;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyDialog;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyWizard;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyWizardPage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.properties.LibraryManagerModel;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class ManageReferencedLibrariesHandler
extends AbstractHandler {
    public static String LIBRARY_DETACHMENT_DOC_URI = "org.polarsys.capella.re.doc/html/09.%20Libraries/9.5.%20Advanced%20Operations.html?cp=6_1_20_4";

    public void setEnabled(Object evaluationContext) {
        IFile file;
        Object element;
        super.setEnabled(evaluationContext);
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        Collection selectedElements = (Collection)context.getDefaultVariable();
        boolean isVisible = false;
        if (selectedElements.size() == 1 && (element = selectedElements.iterator().next()) instanceof IFile && CapellaResourceHelper.isAirdResource((IResource)(file = (IFile)element), (boolean)true)) {
            isVisible = this.getExistingSession(file) != null;
        }
        this.setBaseEnabled(isVisible);
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public boolean isHandled() {
        return true;
    }

    protected Session getExistingSession(IFile file) {
        return SessionManager.INSTANCE.getExistingSession(EcoreUtil2.getURI((IFile)file));
    }

    public void removeHandlerListener(IHandlerListener handlerListener_p) {
        super.removeHandlerListener(handlerListener_p);
    }

    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        TreeSelection selection = (TreeSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event_p);
        IFile file = (IFile)selection.getFirstElement();
        Session session = this.getExistingSession(file);
        return ManageReferencedLibrariesHandler.openManageReferencesWizard(session);
    }

    public static Object openManageReferencesWizard(Session session) {
        IModel rootModel = ILibraryManager.INSTANCE.getModel(session.getTransactionalEditingDomain());
        if (rootModel == null || !(rootModel instanceof IModel.Edit)) {
            return null;
        }
        final String modelName = rootModel.getIdentifier().getName();
        IProperties properties = new PropertiesLoader().getProperties("org.polarsys.capella.core.libraries.manageReferences");
        LibraryManagerModel managerModel = new LibraryManagerModel(session.getTransactionalEditingDomain(), (IModel.Edit)rootModel);
        PropertyContext context = new PropertyContext(properties, (Object)managerModel);
        IRenderers renderers = new RenderersLoader().getRenderers(properties);
        RendererContext rendererContext = new RendererContext(renderers, (IPropertyContext)context);
        PropertyWizard wizard = new PropertyWizard((IPropertyContext)context, (IRendererContext)rendererContext){

            public void addPages() {
                PropertyWizardPage page = new PropertyWizardPage("propertiesEditor", this.getContext(), this.getRendererContext());
                page.setTitle(String.valueOf(modelName) + " management");
                page.setDescription("This wizard helps you to define the libraries that are referenced by the current project (first tab).\nYou can also specify among these libraries which ones must be considered in capella query scopes (second tab).");
                this.addPage((IWizardPage)page);
            }
        };
        PropertyDialog dialog = new PropertyDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        dialog.setHelpAvailable(false);
        dialog.setPageSize(200, 300);
        dialog.create();
        int result = dialog.open();
        List newReferencedLibraries = managerModel.getAllReferencedLibrariesByRootModel();
        ArrayList removedLibraries = new ArrayList(managerModel.getInitialAllReferencedLibrariesByRootModel());
        removedLibraries.removeAll(newReferencedLibraries);
        if (result == 0) {
            if (!removedLibraries.isEmpty() && MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Read the documentation", (String)"Unreferencing libraries may corrupt your model if not done in the proper way.\nMake sure to follow the procedure\nWould you like to open the documentation?")) {
                String localHRef = PlatformUI.getWorkbench().getHelpSystem().resolve(LIBRARY_DETACHMENT_DOC_URI, true).toExternalForm();
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(localHRef);
            }
            session.save((IProgressMonitor)new NullProgressMonitor());
            return Status.OK_STATUS;
        }
        return null;
    }
}

