/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.handlers.transformation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.scope.ScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityTraceHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.rules.IRuleTransformation;
import org.polarsys.capella.core.transition.system.handlers.transformation.CapellaTransformationHandler;
import org.polarsys.kitalpha.transposer.rules.handler.api.IRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.possibilities.MappingPossibilityResolutionException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingPossibility;

public class TopDownTransformationHelper
extends CapellaTransformationHandler {
    public static TopDownTransformationHelper getInstance(IContext context_p) {
        return new TopDownTransformationHelper();
    }

    public IStatus isOrWillBeTransformed(EObject source_p, IContext context_p) {
        boolean result;
        IRulesHandler ruleHandler = (IRulesHandler)context_p.get((Object)"_R_H");
        ITraceabilityHandler handler = (ITraceabilityHandler)context_p.get((Object)"TTrH");
        boolean bl = result = handler.isTraced(source_p, context_p) || this.isTracedInTarget(source_p, context_p);
        if (!result && ScopeHandlerHelper.getInstance((IContext)context_p).isInScope(source_p, context_p)) {
            try {
                IRule rule;
                MappingPossibility mapping = ruleHandler.getApplicablePossibility((Object)source_p);
                if (mapping != null && (rule = ruleHandler.getApplicablePossibility((Object)source_p).getCompleteRule()) != null && rule instanceof IRuleTransformation) {
                    IRuleTransformation deeperRule = (IRuleTransformation)rule;
                    result = deeperRule.applyRequired(source_p, context_p).isOK() && deeperRule.transformRequired(source_p, context_p).isOK();
                }
            }
            catch (MappingPossibilityResolutionException mappingPossibilityResolutionException) {
                // empty catch block
            }
        }
        if (result) {
            return Status.OK_STATUS;
        }
        return new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Element ''{0}'' will not be transitioned.", (Object)LogHelper.getInstance().getText((Object)source_p)));
    }

    public boolean isTracedInTarget(EObject element_p, IContext context_p) {
        ITraceabilityHandler handler = TraceabilityHandlerHelper.getInstance((IContext)context_p);
        boolean result = false;
        try {
            ITraceabilityHandler targetHandler = (ITraceabilityHandler)context_p.get((Object)"TTaH");
            if (!targetHandler.retrieveTracedElements(element_p, context_p).isEmpty()) {
                result = true;
            }
        }
        finally {
            context_p.put((Object)"TH", (Object)handler);
        }
        return result;
    }

    public Collection<EObject> retrieveTargetTracedElements(EObject element_p, IContext context_p) {
        List<EObject> objects = Collections.emptyList();
        ITraceabilityHandler handler = TraceabilityHandlerHelper.getInstance((IContext)context_p);
        try {
            ITraceabilityHandler targetHandler = (ITraceabilityHandler)context_p.get((Object)"TTaH");
            objects = targetHandler.retrieveTracedElements(element_p, context_p);
        }
        finally {
            context_p.put((Object)"TH", (Object)handler);
        }
        return objects;
    }

    public boolean isTrace(EObject element_p, IContext context_p) {
        ITraceabilityTraceHandler tH;
        ITraceabilityHandler sourceHandler = (ITraceabilityHandler)context_p.get((Object)"TTrH");
        return sourceHandler instanceof ITraceabilityTraceHandler && (tH = (ITraceabilityTraceHandler)sourceHandler).isTrace(element_p, context_p);
    }

    public boolean isTargetASystem(EObject object, IContext context) {
        EObject target;
        Collection<EObject> targets = this.retrieveTargetTracedElements(object, context);
        return targets.size() == 1 && (target = targets.iterator().next()) instanceof Component && BlockArchitectureExt.isRootComponent((Component)((Component)target));
    }
}

