/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.launcher;

import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.core.transition.common.handlers.log.ILogHandler;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.launcher.TransitionLauncher;
import org.polarsys.capella.core.transition.system.topdown.handlers.log.TopDownLogHandler;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;

public class HeadlessIntramodelLauncher
extends TransitionLauncher {
    private final String MAPPING = "org.polarsys.capella.core.transition.system.topdown";

    protected void initializeLogHandler() {
        TopDownLogHandler handler = new TopDownLogHandler(this.getReportComponent());
        handler.init(TransitionContext.EMPTY_CONTEXT);
        LogHelper.setInstance((ILogHandler)handler);
    }

    protected String getReportComponent() {
        return "Transition";
    }

    protected String getMapping() {
        return "org.polarsys.capella.core.transition.system.topdown";
    }

    protected String getName() {
        String kind = this.getOptionScope();
        if ("capella.core.transition.system.topdown.actor".equals(kind)) {
            return "Actor Transition";
        }
        if ("capella.core.transition.system.topdown.capability".equals(kind)) {
            return "Capability Transition";
        }
        if ("capella.core.transition.system.topdown.data".equals(kind)) {
            return "Data Transition";
        }
        if ("capella.core.transition.system.topdown.exchangeitem".equals(kind)) {
            return "Exchange Item Transition";
        }
        if ("capella.core.transition.system.topdown.functional".equals(kind)) {
            return "Functional Transition";
        }
        if ("capella.core.transition.system.topdown.interface".equals(kind)) {
            return "Interface Transition";
        }
        if ("capella.core.transition.system.topdown.lc2pc".equals(kind)) {
            return "LC / LA to PC / PA Transition";
        }
        if ("capella.core.transition.system.topdown.oa2capability".equals(kind)) {
            return "Operational Activity to System Capability Transition";
        }
        if ("capella.core.transition.system.topdown.oa2mission".equals(kind)) {
            return "Operational Activity to System Mission Transition";
        }
        if ("capella.core.transition.system.topdown.oc2mission".equals(kind)) {
            return "Operational Capability to System Mission Transition";
        }
        if ("capella.core.transition.system.topdown.oe2actor".equals(kind)) {
            return "Operational Entity to System Actor Transition";
        }
        if ("capella.core.transition.system.topdown.oe2system".equals(kind)) {
            return "Operational Entity to System Transition";
        }
        if ("capella.core.transition.system.topdown.propertyvalue".equals(kind)) {
            return "Property Value Transition";
        }
        if ("capella.core.transition.system.topdown.statemachine".equals(kind)) {
            return "State Machine Transition";
        }
        if ("capella.core.transition.system.topdown.system".equals(kind)) {
            return "System Transition";
        }
        if ("capella.core.transition.system.topdown.pc2ci".equals(kind)) {
            return "PC to CI Transition";
        }
        return this.getOptionScope();
    }

    protected String getOptionScope() {
        return "capella.core.transition.system.topdown";
    }

    protected WorkflowActivityParameter buildPreAnalysisActivities() {
        WorkflowActivityParameter parameter = new WorkflowActivityParameter();
        if (this.getTransposer() != null) {
            parameter.addActivity("org.polarsys.capella.core.transition.system.topdown.activities.InitializeTransitionActivity");
            GenericParameter param2 = new GenericParameter("org.polarsys.capella.core.transition.ruleHandler", (Object)this.getTransposer().getRulesHandler(), "Transposer Rule handler");
            parameter.addParameter("org.polarsys.capella.core.transition.system.topdown.activities.InitializeTransitionActivity", param2);
            GenericParameter param3 = new GenericParameter("_OS", (Object)this.getOptionScope(), "Option scope");
            parameter.addParameter("org.polarsys.capella.core.transition.system.topdown.activities.InitializeTransitionActivity", param3);
            parameter.addActivity("org.polarsys.capella.core.transition.system.topdown.activities.InitializeTransformationActivity");
            parameter.addActivity("org.polarsys.capella.core.transition.common.activities.InitializeScopeActivity");
        }
        return parameter;
    }

    protected WorkflowActivityParameter buildDiffMergeActivities() {
        WorkflowActivityParameter parameter = new WorkflowActivityParameter();
        if (this.getTransposer() != null) {
            parameter.addActivity("org.polarsys.capella.core.transition.common.activities.PostTransformationActivity");
            parameter.addActivity("org.polarsys.capella.core.transition.system.topdown.activities.InitializeDiffMergeActivity");
            parameter.addActivity("org.polarsys.capella.core.transition.system.topdown.activities.DifferencesComputingActivity");
            parameter.addActivity("org.polarsys.capella.core.transition.system.activities.DifferencesMergingActivity");
        }
        return parameter;
    }

    protected WorkflowActivityParameter buildFinalizationActivities() {
        WorkflowActivityParameter parameter = new WorkflowActivityParameter();
        if (this.getTransposer() != null) {
            parameter.addActivity("org.polarsys.capella.core.transition.common.activities.PostDiffMergeActivity");
            parameter.addActivity("org.polarsys.capella.core.transition.common.activities.FinalizeTransitionActivity");
        }
        return parameter;
    }
}

