/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.properties.fields;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.core.properties.Messages;
import org.polarsys.capella.core.diagram.helpers.TitleBlockHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.helpers.LockHelper;

public class TitleBlockBasicElementGroup
extends AbstractSemanticField {
    private static final String NAME = "Name:";
    private static final String CONTENT = "Content:";
    private static final String INTERPRETER_ERROR = "The expression is not valid";
    protected Text nameTextField;
    protected Text contentTextField;
    protected CLabel errorLabel;
    protected boolean proposalsLoaded;

    public TitleBlockBasicElementGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(widgetFactory);
        Group textGroup = widgetFactory.createGroup(parent, "");
        textGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        textGroup.setLayoutData((Object)gd);
        this.nameTextField = this.createTextField(textGroup, Messages.getString("NamedElement.NameLabel"));
        this.contentTextField = this.createTextField(textGroup, Messages.getString("NamedElement.ContentLabel"));
        this.errorLabel = widgetFactory.createCLabel(parent, "");
        this.errorLabel.setRightMargin(300);
        this.errorLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.proposalsLoaded = false;
    }

    private Text createTextField(Group textGroup, String textLabel) {
        this.widgetFactory.createCLabel((Composite)textGroup, textLabel);
        Text textField = this.widgetFactory.createText((Composite)textGroup, "");
        textField.addFocusListener((FocusListener)this);
        textField.addKeyListener((KeyListener)this);
        textField.setLayoutData((Object)new GridData(768));
        return textField;
    }

    public void loadData(EObject semanticElement, String name, String content) {
        this.errorLabel.setText("");
        if (!this.proposalsLoaded) {
            TitleBlockHelper.getServicesProposals((Text)this.contentTextField, (EObject)TitleBlockHelper.getReferencedElement((EObject)semanticElement));
            this.proposalsLoaded = true;
        }
        super.loadData(semanticElement, null);
        if (semanticElement != null) {
            if (this.nameTextField != null) {
                this.setTextValue(this.nameTextField, name);
            }
            if (this.contentTextField != null) {
                this.setTextValue(this.contentTextField, content);
            }
        }
    }

    protected void setTextValue(Text text, String value) {
        if (value != null) {
            text.setText(value);
        }
    }

    protected void fillTextField(Text textField) {
        if (textField.equals(this.nameTextField)) {
            this.setFieldValue(this.semanticElement, NAME, this.nameTextField.getText());
        } else if (textField.equals(this.contentTextField)) {
            this.setFieldValue(this.semanticElement, CONTENT, this.contentTextField.getText());
        }
    }

    private void setFieldValue(EObject object, String field, Object value) {
        boolean errorSet = false;
        String nameValue = this.nameTextField.getText();
        String contentValue = this.contentTextField.getText();
        if (field.equals(CONTENT)) {
            errorSet = this.setContentErrorField(this.semanticElement);
            contentValue = value.toString();
        }
        if (field.equals(NAME)) {
            nameValue = value.toString();
        }
        if (!(errorSet || ((String)((DAnnotation)object).getDetails().get((Object)field)).equals(value.toString()) && !this.nameTextField.getText().isEmpty())) {
            this.updateTitleBlock(object, nameValue, contentValue);
        }
    }

    private void updateTitleBlock(final EObject object, final String nameValue, final String contentField) {
        final DRepresentationDescriptor descriptor = (DRepresentationDescriptor)object.eContainer();
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                ((DAnnotation)object).getDetails().put((Object)TitleBlockBasicElementGroup.NAME, (Object)nameValue);
                ((DAnnotation)object).getDetails().put((Object)TitleBlockBasicElementGroup.CONTENT, (Object)contentField);
                if (contentField.contains("capella:")) {
                    String serviceName = TitleBlockHelper.getServiceName((String)contentField);
                    TitleBlockBasicElementGroup.this.nameTextField.setText(TitleBlockHelper.getServiceName((String)contentField));
                    ((DAnnotation)object).getDetails().put((Object)TitleBlockBasicElementGroup.NAME, (Object)serviceName);
                }
                RefreshRepresentationsCommand refreshCommand = new RefreshRepresentationsCommand(TransactionUtil.getEditingDomain((EObject)descriptor), (IProgressMonitor)new NullProgressMonitor(), new DRepresentation[]{descriptor.getRepresentation()});
                refreshCommand.execute();
            }
        };
        this.executeCommand((ICommand)command);
    }

    private boolean setContentErrorField(EObject semanticElement) {
        boolean errorSet = false;
        DAnnotation titleBlockCell = (DAnnotation)semanticElement;
        EObject container = titleBlockCell.eContainer();
        if (container instanceof DDiagram) {
            DDiagram diagram = (DDiagram)container;
            DAnnotation titleBlock = TitleBlockHelper.getParentTitleBlock((DAnnotation)titleBlockCell);
            Object evaluateResult = TitleBlockHelper.getResultOfExpression((DRepresentationDescriptor)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram), (String)this.contentTextField.getText(), (DAnnotation)titleBlock);
            if (evaluateResult instanceof EvaluationException) {
                this.errorLabel.setText(INTERPRETER_ERROR);
                errorSet = true;
            } else {
                this.errorLabel.setText("");
            }
        }
        return errorSet;
    }

    public void setEnabled(boolean enabled) {
        LockHelper.getInstance().enable((Control)this.nameTextField, enabled);
        LockHelper.getInstance().enable((Control)this.contentTextField, enabled);
    }

    public void loadData(EObject semanticElement) {
    }
}

