/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers.cache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.polarsys.capella.common.helpers.cache.CachedBiFunction;
import org.polarsys.capella.common.helpers.cache.CachedFunction;
import org.polarsys.capella.common.helpers.cache.Couple;
import org.polarsys.capella.common.helpers.cache.Triplet;

public class Cache {
    private Map<Object, Object> cachedResult = new ConcurrentHashMap<Object, Object>();

    public <P, R> R get(Function<P, R> function, P parameter) {
        Couple<Function<P, R>, P> key = new Couple<Function<P, R>, P>(function, parameter);
        Object resultObject = this.cachedResult.get(key);
        if (resultObject == null) {
            R result = function.apply(parameter);
            Optional<Object> encapsulatedResult = result instanceof List ? Optional.of(Collections.unmodifiableList((List)result)) : (result instanceof Set ? Optional.of(Collections.unmodifiableSet((Set)result)) : (result instanceof Map ? Optional.of(Collections.unmodifiableMap((Map)result)) : Optional.ofNullable(result)));
            this.cachedResult.put(key, encapsulatedResult);
            return result;
        }
        Optional result = (Optional)resultObject;
        return result.orElse(null);
    }

    public <P, R> R get(CachedFunction<P, R> function, P parameter) {
        Couple<CachedFunction<P, R>, P> key = new Couple<CachedFunction<P, R>, P>(function, parameter);
        Object resultObject = this.cachedResult.get(key);
        if (resultObject == null) {
            R result = function.withoutCache(parameter);
            Optional<Object> encapsulatedResult = result instanceof List ? Optional.of(Collections.unmodifiableList((List)result)) : (result instanceof Set ? Optional.of(Collections.unmodifiableSet((Set)result)) : (result instanceof Map ? Optional.of(Collections.unmodifiableMap((Map)result)) : Optional.ofNullable(result)));
            this.cachedResult.put(key, encapsulatedResult);
            return result;
        }
        Optional result = (Optional)resultObject;
        return result.orElse(null);
    }

    public <P1, P2, R> R get(CachedBiFunction<P1, P2, R> function, P1 parameter1, P2 parameter2) {
        Triplet<CachedBiFunction<P1, P2, R>, P1, P2> key = new Triplet<CachedBiFunction<P1, P2, R>, P1, P2>(function, parameter1, parameter2);
        Object resultObject = this.cachedResult.get(key);
        if (resultObject == null) {
            R result = function.withoutCache(parameter1, parameter2);
            Optional<Object> encapsulatedResult = result instanceof List ? Optional.of(Collections.unmodifiableList((List)result)) : (result instanceof Set ? Optional.of(Collections.unmodifiableSet((Set)result)) : (result instanceof Map ? Optional.of(Collections.unmodifiableMap((Map)result)) : Optional.ofNullable(result)));
            this.cachedResult.put(key, encapsulatedResult);
            return result;
        }
        Optional result = (Optional)resultObject;
        return result.orElse(null);
    }

    public void clearCache() {
        this.cachedResult.clear();
    }

    public <T, R> void clearCache(CachedFunction<T, R> f) {
        List toBeRemoved = this.cachedResult.keySet().stream().filter(key -> key instanceof Couple).filter(couple -> ((Couple)couple).getFirst() == f).collect(Collectors.toList());
        for (Object keyToBeRemoved : toBeRemoved) {
            this.cachedResult.remove(keyToBeRemoved);
        }
    }

    public <T1, T2, R> void clearCache(CachedBiFunction<T1, T2, R> f) {
        List toBeRemoved = this.cachedResult.keySet().stream().filter(key -> key instanceof Triplet).filter(triplet -> ((Triplet)triplet).getFirst() == f).collect(Collectors.toList());
        for (Object keyToBeRemoved : toBeRemoved) {
            this.cachedResult.remove(keyToBeRemoved);
        }
    }
}

