/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers.operations;

import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.polarsys.capella.common.helpers.operations.ILongRunningListener;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;

public final class LongRunningListenersRegistry
implements ILongRunningListener {
    private static final Logger logger = Logger.getLogger((String)LongRunningListenersRegistry.class.getName());
    private static LongRunningListenersRegistry instance;
    private Collection<ILongRunningListener> listeners;

    private LongRunningListenersRegistry() {
    }

    public ILongRunningListener[] getListeners() {
        if (this.listeners == null) {
            IConfigurationElement[] configurationElements;
            this.listeners = new HashSet<ILongRunningListener>(0);
            IConfigurationElement[] iConfigurationElementArray = configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.common.helpers", (String)"longRunningOperationsListener");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    ILongRunningListener listener = (ILongRunningListener)configurationElement.createExecutableExtension("class");
                    this.listeners.add(listener);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return this.listeners.toArray(new ILongRunningListener[this.listeners.size()]);
    }

    @Override
    public boolean isListenerFor(Class<?> longRunningOperationClass) {
        return false;
    }

    @Override
    public void operationAborted(Class<?> operationClass) {
        if (this.listeners == null) {
            this.getListeners();
        }
        for (ILongRunningListener listener : this.listeners) {
            try {
                if (!listener.isListenerFor(operationClass)) continue;
                listener.operationAborted(operationClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void operationEnded(Class<?> operationClass) {
        if (this.listeners == null) {
            this.getListeners();
        }
        for (ILongRunningListener listener : this.listeners) {
            try {
                if (!listener.isListenerFor(operationClass)) continue;
                listener.operationEnded(operationClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void operationStarting(Class<?> operationClass) {
        if (this.listeners == null) {
            this.getListeners();
        }
        for (ILongRunningListener listener : this.listeners) {
            try {
                if (!listener.isListenerFor(operationClass)) continue;
                listener.operationStarting(operationClass);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static LongRunningListenersRegistry getInstance() {
        if (instance == null) {
            instance = new LongRunningListenersRegistry();
        }
        return instance;
    }
}

