/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractTextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class TextPainter
extends AbstractTextPainter {
    private boolean calculateWrappedHeight = false;

    public TextPainter() {
        this(false, true);
    }

    public TextPainter(boolean wrapText, boolean paintBg) {
        this(wrapText, paintBg, 0);
    }

    public TextPainter(boolean wrapText, boolean paintBg, int spacing) {
        this(wrapText, paintBg, spacing, false);
    }

    public TextPainter(boolean wrapText, boolean paintBg, boolean calculate) {
        this(wrapText, paintBg, 0, calculate);
    }

    public TextPainter(boolean wrapText, boolean paintBg, boolean calculateByTextLength, boolean calculateByTextHeight) {
        this(wrapText, paintBg, 0, calculateByTextLength, calculateByTextHeight);
    }

    public TextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        super(wrapText, paintBg, spacing, calculate);
    }

    public TextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculateByTextLength, boolean calculateByTextHeight) {
        super(wrapText, paintBg, spacing, calculateByTextLength, calculateByTextHeight);
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return this.getLengthFromCache(gc, this.convertDataType(cell, configRegistry)) + this.spacing * 2 + 1;
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        String text = this.convertDataType(cell, configRegistry);
        if (!this.calculateWrappedHeight) {
            return gc.textExtent((String)text).y + this.spacing * 2 + 1 + (this.getNumberOfNewLines(text) - 1) * this.lineSpacing;
        }
        Rectangle adjustedBounds = cell.getLayer().getLayerPainter().adjustCellBounds(cell.getColumnPosition(), cell.getRowPosition(), cell.getBounds());
        text = this.getTextToDisplay(cell, gc, adjustedBounds.width, text);
        int numberOfNewLines = this.getNumberOfNewLines(text);
        return gc.getFontMetrics().getHeight() * numberOfNewLines + this.lineSpacing * (numberOfNewLines - 1) + this.spacing * 2;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        if (this.paintBg) {
            super.paintCell(cell, gc, rectangle, configRegistry);
        }
        if (this.paintFg) {
            Rectangle originalClipping = gc.getClipping();
            gc.setClipping(rectangle.intersection(originalClipping));
            IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
            this.setupGCFromConfig(gc, cellStyle);
            int fontHeight = gc.getFontMetrics().getHeight();
            String text = this.convertDataType(cell, configRegistry);
            text = this.getTextToDisplay(cell, gc, rectangle.width, text);
            int numberOfNewLines = this.getNumberOfNewLines(text);
            int contentHeight = fontHeight * numberOfNewLines + this.lineSpacing * (numberOfNewLines - 1) + this.spacing * 2;
            int contentToCellDiff = cell.getBounds().height - rectangle.height;
            if (this.performRowResize(contentHeight, rectangle)) {
                ILayer layer = cell.getLayer();
                int rowPosition = cell.getRowPosition();
                if (cell.isSpannedCell()) {
                    rowPosition = cell.getOriginRowPosition() + cell.getRowSpan() - 1;
                    int i = cell.getOriginRowPosition();
                    while (i < rowPosition) {
                        contentHeight -= layer.getRowHeightByPosition(i);
                        ++i;
                    }
                }
                layer.doCommand(new RowResizeCommand(layer, rowPosition, contentHeight + contentToCellDiff, true));
            }
            if (numberOfNewLines == 1) {
                int contentWidth = Math.min(this.getLengthFromCache(gc, text), rectangle.width);
                gc.drawText(text, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentWidth) + this.spacing, rectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentHeight) + this.spacing, 7);
                int x = rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, contentWidth) + this.spacing;
                int y = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentHeight) + this.spacing;
                int length = gc.textExtent((String)text).x;
                this.paintDecoration(cellStyle, gc, x, y, length, fontHeight);
            } else {
                String[] lines;
                int yStartPos = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, rectangle, contentHeight);
                String[] stringArray = lines = text.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), rectangle.width);
                    gc.drawText(line, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, lineContentWidth) + this.spacing, yStartPos + this.spacing, 7);
                    int x = rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, rectangle, lineContentWidth) + this.spacing;
                    int y = yStartPos + this.spacing;
                    int length = gc.textExtent((String)line).x;
                    this.paintDecoration(cellStyle, gc, x, y, length, fontHeight);
                    yStartPos += fontHeight;
                    yStartPos += this.lineSpacing;
                    ++n2;
                }
            }
            gc.setClipping(originalClipping);
            this.resetGC(gc);
        }
    }

    @Override
    protected void setNewMinLength(ILayerCell cell, int contentWidth) {
        int cellLength = cell.getBounds().width;
        if (cellLength < contentWidth) {
            ILayer layer = cell.getLayer();
            int columnPosition = cell.getColumnPosition();
            if (cell.isSpannedCell()) {
                columnPosition = cell.getOriginColumnPosition() + cell.getColumnSpan() - 1;
                int i = cell.getOriginColumnPosition();
                while (i < columnPosition) {
                    contentWidth -= layer.getColumnWidthByPosition(i);
                    ++i;
                }
            }
            layer.doCommand(new ColumnResizeCommand(layer, columnPosition, contentWidth, true));
        }
    }

    @Override
    protected int calculatePadding(ILayerCell cell, int availableLength) {
        return cell.getBounds().width - availableLength;
    }

    protected boolean performRowResize(int contentHeight, Rectangle rectangle) {
        return contentHeight > rectangle.height && this.calculateByTextHeight;
    }

    public boolean isCalculateWrappedHeight() {
        return this.calculateWrappedHeight;
    }

    public void setCalculateWrappedHeight(boolean calculateWrappedHeight) {
        this.calculateWrappedHeight = calculateWrappedHeight;
    }
}

