/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tooltip;

import java.util.List;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.CellDisplayConversionUtils;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.PasswordTextPainter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class NatTableContentTooltip
extends DefaultToolTip {
    protected NatTable natTable;
    protected String[] tooltipRegions;

    public NatTableContentTooltip(NatTable natTable, String ... tooltipRegions) {
        super((Control)natTable, 2, false);
        this.setPopupDelay(500);
        this.setShift(new Point(10, 10));
        this.activate();
        this.natTable = natTable;
        this.tooltipRegions = tooltipRegions;
    }

    public NatTableContentTooltip(NatTable natTable, int style, boolean manualActivation, String ... tooltipRegions) {
        super((Control)natTable, style, manualActivation);
        this.setPopupDelay(500);
        this.setShift(new Point(10, 10));
        this.activate();
        this.natTable = natTable;
        this.tooltipRegions = tooltipRegions;
    }

    protected Object getToolTipArea(Event event) {
        int col = this.natTable.getColumnPositionByX(event.x);
        int row = this.natTable.getRowPositionByY(event.y);
        return new Point(col, row);
    }

    protected String getText(Event event) {
        String tooltipValue;
        ICellPainter painter;
        int row;
        int col = this.natTable.getColumnPositionByX(event.x);
        ILayerCell cell = this.natTable.getCellByPosition(col, row = this.natTable.getRowPositionByY(event.y));
        if (cell != null && this.isVisibleContentPainter(painter = this.natTable.getConfigRegistry().getConfigAttribute(CellConfigAttributes.CELL_PAINTER, DisplayMode.NORMAL, (List<String>)cell.getConfigLabels())) && (tooltipValue = CellDisplayConversionUtils.convertDataType(cell, this.natTable.getConfigRegistry())).length() > 0) {
            return tooltipValue;
        }
        return null;
    }

    protected boolean isVisibleContentPainter(ICellPainter painter) {
        if (painter instanceof PasswordTextPainter) {
            return false;
        }
        if (painter instanceof CellPainterWrapper) {
            return this.isVisibleContentPainter(((CellPainterWrapper)painter).getWrappedPainter());
        }
        return true;
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean regionCheckPassed = false;
        if (this.tooltipRegions.length > 0) {
            LabelStack regionLabels = this.natTable.getRegionLabelsByXY(event.x, event.y);
            if (regionLabels != null) {
                String[] stringArray = this.tooltipRegions;
                int n = this.tooltipRegions.length;
                int n2 = 0;
                while (n2 < n) {
                    String label = stringArray[n2];
                    if (regionLabels.hasLabel(label)) {
                        regionCheckPassed = true;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            regionCheckPassed = true;
        }
        if (regionCheckPassed && this.getText(event) != null) {
            return super.shouldCreateToolTip(event);
        }
        return false;
    }
}

