/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.massactions.core.edit.control.many;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.polarsys.capella.common.ui.massactions.core.activator.MECoreCapellaActivator;
import org.polarsys.capella.common.ui.massactions.core.edit.editor.many.ManyRefTransitionalValue;
import org.polarsys.capella.common.ui.massactions.core.shared.helper.CommonElementsHelper;
import org.polarsys.capella.common.ui.massactions.core.shared.helper.container.CommonBQInput;
import org.polarsys.capella.common.ui.massactions.core.shared.helper.container.CommonBQResult;
import org.polarsys.capella.common.ui.massactions.core.shared.messages.Messages;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.kitalpha.massactions.core.control.AbstractMAPrimitiveCellControl;
import org.polarsys.kitalpha.massactions.core.helper.EObjectImageProvider;

public class ManyRefCellControl
extends AbstractMAPrimitiveCellControl {
    private static final int DISPLAY_VALUE_MAX_LENGTH = 60;
    private ManyRefTransitionalValue canonicalValue;
    private List<CommonBQInput> commonBQInputs;
    private Text editorValueText;
    private ToolItem editorIconToolItem;
    private final SelectionAdapter browseSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            CommonBQResult commonBusinessQueryResult;
            if (ManyRefCellControl.this.commonBQInputs != null && !(commonBusinessQueryResult = CommonElementsHelper.getAllCommonBusinessQueryResults(ManyRefCellControl.this.commonBQInputs)).isEmpty()) {
                List<EObject> commonAvailableElements = commonBusinessQueryResult.getCommonAvailableElements();
                List<EObject> commonCurrentElements = commonBusinessQueryResult.getCommonCurrentElements();
                commonAvailableElements.removeAll(commonCurrentElements);
                List selectedElements = DialogHelper.openTransferDialog((Control)ManyRefCellControl.this, commonCurrentElements, commonAvailableElements, (String)Messages.MANY_REF_DIALOG_TITLE, (String)Messages.MANY_REF_DIALOG_MESSAGE);
                if (selectedElements != null) {
                    ManyRefTransitionalValue selection = new ManyRefTransitionalValue(selectedElements, commonCurrentElements);
                    ManyRefCellControl.this.setCanonicalValue(selection);
                }
            }
        }
    };

    public ManyRefCellControl(Composite parent, int style, IDisplayConverter displayConverter, Map<String, EStructuralFeature> featureMap) {
        super(parent, style, displayConverter, featureMap);
        this.initialize();
    }

    protected void initialize() {
        GridData gridData = new GridData(4, 4, true, true);
        this.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        ToolBar iconToolBar = new ToolBar((Composite)this, 256);
        this.editorIconToolItem = new ToolItem(iconToolBar, 32);
        this.editorIconToolItem.setEnabled(false);
        this.editorValueText = new Text((Composite)this, 4);
        this.editorValueText.setEditable(false);
        this.editorValueText.setCursor(Display.getCurrent().getSystemCursor(0));
        this.editorValueText.setText(Messages.NO_COMMON_VALUE_TEXT);
        this.editorValueText.setLayoutData((Object)new GridData(4, 4, true, true));
        ToolBar toolbar = new ToolBar((Composite)this, 256);
        ToolItem browse = new ToolItem(toolbar, 8);
        browse.setToolTipText(Messages.ELEMENT_SELECTION_TOOLTIP_TEXT);
        Image browseImage = MECoreCapellaActivator.getDefault().getImageRegistry().get("IMAGE_BROWSE");
        browse.setImage(browseImage);
        browse.addSelectionListener((SelectionListener)this.browseSelectionAdapter);
    }

    public void setSelectedRowObjects(List<EObject> selectedRowObjects) {
        super.setSelectedRowObjects(selectedRowObjects);
        this.commonBQInputs = selectedRowObjects.stream().map(rowObject -> new CommonBQInput((EObject)rowObject, (EStructuralFeature)this.featureMap.get(rowObject.eClass().getName()))).collect(Collectors.toList());
    }

    public Object getEditorValue() {
        ManyRefTransitionalValue currentCanonicalValue = this.getCanonicalValue();
        return this.getDisplayConverterValue(currentCanonicalValue);
    }

    public void setEditorValue(Object editorValue) {
        String stringValue;
        if (editorValue instanceof String && !(stringValue = (String)editorValue).isEmpty()) {
            if (stringValue.length() > 60) {
                stringValue = String.valueOf(stringValue.substring(0, 57)) + "...";
            }
            this.editorValueText.setText(stringValue);
        }
    }

    public ManyRefTransitionalValue getCanonicalValue() {
        return this.canonicalValue;
    }

    public void setCanonicalValue(Object value) {
        if (value != null) {
            List<EObject> actualCanonicalValue = Collections.emptyList();
            if (value instanceof List) {
                actualCanonicalValue = (List<EObject>)value;
            } else if (value instanceof ManyRefTransitionalValue) {
                this.canonicalValue = (ManyRefTransitionalValue)value;
                actualCanonicalValue = this.canonicalValue.getCommonSelectedValues();
            }
            Object editorValue = this.getDisplayConverterValue(actualCanonicalValue);
            this.setEditorValue(editorValue);
            if (!actualCanonicalValue.isEmpty()) {
                Image image = EObjectImageProvider.getInstance().getImage((Object)actualCanonicalValue.get(0));
                this.editorIconToolItem.setDisabledImage(image);
                this.editorIconToolItem.setImage(image);
            }
        }
    }
}

