/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.OperationalAnalysisExt;
import org.polarsys.capella.core.model.helpers.PhysicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.actions.WizardActionHelper;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class AllocationManagementData {
    private String _dataMessage = Messages.AllocationManagementWizardAction_Title;
    private AllocationSelectionType _allocationType = AllocationSelectionType.NONE;
    private boolean _sourceDataVoid = false;

    public static AllocationManagementData getInstance() {
        return new AllocationManagementData();
    }

    public List<CapellaElement> getCorrespondingData(List<EObject> element) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        if (element == null) {
            return result;
        }
        if (this.areAllElementFunctions(element)) {
            ArrayList<EObject> nonAllocatedFunctions = new ArrayList<EObject>(0);
            for (EObject object : element) {
                if (!AbstractFunctionExt.isAbstractFunctionAvailableForAllocation((EObject)object)) continue;
                nonAllocatedFunctions.add(object);
            }
            if (nonAllocatedFunctions.isEmpty()) {
                this.setSourceDataVoid(true);
            }
            this.setDataMessage(this.createDataMessage(nonAllocatedFunctions, AllocationSelectionType.FUNCTION_ALLOCATION));
            this.setAllocationType(AllocationSelectionType.FUNCTION_ALLOCATION);
            return this.getAllComponentsFromCurrentLayers(nonAllocatedFunctions);
        }
        if (this.areAllElementExchangeItems(element)) {
            if (element.isEmpty()) {
                this.setSourceDataVoid(true);
            }
            this.setDataMessage(this.createDataMessage(element, AllocationSelectionType.EXCHANGE_ITEM_ALLOCATION));
            this.setAllocationType(AllocationSelectionType.EXCHANGE_ITEM_ALLOCATION);
            return this.getAllInterfacesFromAllLayers(element);
        }
        if (WizardActionHelper.areAllElementFunctionalExchange(element)) {
            ArrayList<EObject> nonAllocatedFunExcs = new ArrayList<EObject>(0);
            for (EObject object : element) {
                if (!AbstractFunctionExt.isFunctionExchangeAvailableForAllocation((EObject)object)) continue;
                nonAllocatedFunExcs.add(object);
            }
            if (nonAllocatedFunExcs.isEmpty()) {
                this.setSourceDataVoid(true);
            }
            this.setDataMessage(this.createDataMessage(nonAllocatedFunExcs, AllocationSelectionType.FUNCTIONAL_EXCHANGE_ALLOCATION));
            this.setAllocationType(AllocationSelectionType.FUNCTIONAL_EXCHANGE_ALLOCATION);
            return this.getAvailableAllocatingComponentExchanges2(nonAllocatedFunExcs);
        }
        if (WizardActionHelper.areAllElementsComponentExchanges(element)) {
            ArrayList<EObject> nonAllocatedCompExcs = new ArrayList<EObject>(0);
            for (EObject object : element) {
                if (!AbstractFunctionExt.isComponentExchangeAvailableForAllocation((EObject)object)) continue;
                nonAllocatedCompExcs.add(object);
            }
            if (nonAllocatedCompExcs.isEmpty()) {
                this.setSourceDataVoid(true);
            }
            this.setDataMessage(this.createDataMessage(nonAllocatedCompExcs, AllocationSelectionType.COMPONENT_EXCHANGE_ALLOCATION));
            this.setAllocationType(AllocationSelectionType.COMPONENT_EXCHANGE_ALLOCATION);
            return this.getAvailableAllocatingPhysicalLinks(nonAllocatedCompExcs);
        }
        if (this.areAllElementPCParts(element)) {
            ArrayList<EObject> nonDeployedPCParts = new ArrayList<EObject>(0);
            for (EObject object : element) {
                if (!AbstractFunctionExt.isPCPartAvailableForDeployment((EObject)object)) continue;
                nonDeployedPCParts.add(object);
            }
            if (nonDeployedPCParts.isEmpty()) {
                this.setSourceDataVoid(true);
            }
            this.setDataMessage(this.createDataMessage(nonDeployedPCParts, AllocationSelectionType.PHYSICAL_PART_DEPLOYMENT));
            this.setAllocationType(AllocationSelectionType.PHYSICAL_PART_DEPLOYMENT);
            return this.getAllPartsFromPCLayers(nonDeployedPCParts);
        }
        return result;
    }

    private List<CapellaElement> getAllComponentsFromCurrentLayers(List<EObject> element) {
        ArrayList temp = new ArrayList(0);
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>(0);
        if (!element.isEmpty() && element.get(0) != null) {
            BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)element.get(0));
            if (arch == null) {
                return result;
            }
            temp.addAll(BlockArchitectureExt.getAllComponents((BlockArchitecture)arch));
            Component firstComponent = arch.getSystem();
            if (!(arch instanceof SystemAnalysis) && firstComponent != null) {
                temp.remove(firstComponent);
            }
            for (CapellaElement capellaElement : temp) {
                if (!this.isNotNodePhysicalComponent(capellaElement) && !ComponentExt.isActor((EObject)capellaElement)) continue;
                result.add(capellaElement);
            }
            if (arch instanceof OperationalAnalysis) {
                result.addAll(OperationalAnalysisExt.getAllRoles((OperationalAnalysis)((OperationalAnalysis)arch)));
            }
        }
        return result;
    }

    private boolean isNotNodePhysicalComponent(CapellaElement capellaElement) {
        PhysicalComponent comp;
        return !(capellaElement instanceof PhysicalComponent) || (comp = (PhysicalComponent)capellaElement).getNature() != PhysicalComponentNature.NODE;
    }

    private List<CapellaElement> getAllInterfacesFromAllLayers(List<EObject> element) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>(0);
        if (!element.isEmpty()) {
            SystemEngineering sysEng = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)((CapellaElement)element.get(0)));
            EList architectures = sysEng.getOwnedArchitectures();
            for (ModellingArchitecture modellingArchitecture : architectures) {
                result.addAll(SystemEngineeringExt.getAllInterfaces((ModellingArchitecture)modellingArchitecture));
            }
        }
        return result;
    }

    private List<CapellaElement> getAllPartsFromPCLayers(List<EObject> nonDeployedPCParts) {
        BlockArchitecture arch;
        ArrayList<CapellaElement> components = new ArrayList<CapellaElement>();
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        if (!nonDeployedPCParts.isEmpty() && (arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)nonDeployedPCParts.get(0))) != null && arch instanceof PhysicalArchitecture) {
            components.addAll(BlockArchitectureExt.getAllComponents((BlockArchitecture)arch));
            if (components.isEmpty()) {
                return components;
            }
            Component firstComponent = arch.getSystem();
            if (firstComponent != null) {
                components.remove(firstComponent);
            }
            for (CapellaElement capellaElement : components) {
                if (!(capellaElement instanceof PhysicalComponent)) continue;
                PhysicalComponent comp = (PhysicalComponent)capellaElement;
                EList parts = comp.getAbstractTypedElements();
                for (AbstractTypedElement abstractTypedElement : parts) {
                    if (!(abstractTypedElement instanceof Part)) continue;
                    result.add((CapellaElement)((Part)abstractTypedElement));
                }
            }
        }
        result.removeAll(nonDeployedPCParts);
        return result;
    }

    private List<CapellaElement> getAvailableAllocatingComponentExchanges2(List<EObject> nonAllocatedFunExcs) {
        BlockArchitecture arch;
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>(0);
        if (nonAllocatedFunExcs.isEmpty()) {
            return result;
        }
        EObject object = nonAllocatedFunExcs.get(0);
        if (object != null && (arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)object)) != null) {
            for (ComponentExchange link : BlockArchitectureExt.getAllComponentExchanges((BlockArchitecture)arch)) {
                IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(FaPackage.Literals.COMPONENT_EXCHANGE, (EStructuralFeature)FaPackage.Literals.COMPONENT_EXCHANGE__OWNED_COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATIONS);
                List compExchanges = query.getAvailableElements((EObject)link);
                for (EObject functionalExchange : compExchanges) {
                    if (!nonAllocatedFunExcs.contains(functionalExchange)) continue;
                    result.add((CapellaElement)link);
                }
            }
        }
        return result;
    }

    private List<CapellaElement> getAvailableAllocatingPhysicalLinks(List<EObject> nonAllocatedCompExcs) {
        BlockArchitecture arch;
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>(0);
        if (nonAllocatedCompExcs.isEmpty()) {
            return result;
        }
        EObject object = nonAllocatedCompExcs.get(0);
        if (object != null && (arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)object)) instanceof PhysicalArchitecture) {
            for (PhysicalLink link : PhysicalArchitectureExt.getAllPhysicalLinks((PhysicalArchitecture)((PhysicalArchitecture)arch))) {
                IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CsPackage.Literals.PHYSICAL_LINK, (EStructuralFeature)FaPackage.Literals.COMPONENT_EXCHANGE_ALLOCATOR__OWNED_COMPONENT_EXCHANGE_ALLOCATIONS);
                List compExchanges = query.getAvailableElements((EObject)link);
                for (EObject compExchange : compExchanges) {
                    if (!nonAllocatedCompExcs.contains(compExchange)) continue;
                    result.add((CapellaElement)link);
                }
            }
        }
        return result;
    }

    private boolean areAllElementFunctions(List<EObject> elements) {
        boolean flag = false;
        for (EObject object : elements) {
            if (!(object instanceof AbstractFunction)) {
                return false;
            }
            if (!(object instanceof AbstractFunction)) continue;
            flag = true;
        }
        return flag;
    }

    private boolean areAllElementPCParts(List<EObject> elements) {
        boolean flag = false;
        for (EObject object : elements) {
            Part part;
            AbstractType abstractType;
            if (!(object instanceof Part)) {
                return false;
            }
            if (!(object instanceof Part) || (abstractType = (part = (Part)object).getAbstractType()) == null || !(abstractType instanceof PhysicalComponent)) continue;
            flag = true;
        }
        return flag;
    }

    private boolean areAllElementExchangeItems(List<EObject> elements) {
        boolean flag = false;
        for (EObject object : elements) {
            if (!(object instanceof ExchangeItem)) {
                return false;
            }
            if (!(object instanceof ExchangeItem)) continue;
            flag = true;
        }
        return flag;
    }

    public boolean isMultiSelection(List<EObject> elements) {
        EObject object;
        return this.isValidSelection(elements) && (object = elements.get(0)) instanceof ExchangeItem;
    }

    public boolean isValidSelection(List<EObject> elements) {
        if (this.areAllElementFunctions(elements)) {
            return true;
        }
        if (this.areAllElementExchangeItems(elements)) {
            return true;
        }
        if (this.areAllElementPCParts(elements)) {
            return true;
        }
        if (WizardActionHelper.areAllElementFunctionalExchange(elements)) {
            return true;
        }
        return WizardActionHelper.areAllElementsComponentExchanges(elements);
    }

    private String createDataMessage(List<EObject> element, AllocationSelectionType allocationSelectionType) {
        String result = "";
        String plural = this.getPluralString(element, false);
        String elementsNames = this.getElementsNames(element);
        if (allocationSelectionType == AllocationSelectionType.FUNCTION_ALLOCATION) {
            result = NLS.bind((String)Messages.Allocation_Functions_Selection_Message, (Object[])new String[]{plural, elementsNames});
        } else if (allocationSelectionType == AllocationSelectionType.EXCHANGE_ITEM_ALLOCATION) {
            result = NLS.bind((String)Messages.Allocation_ExchangeItems_Selection_Message, (Object[])new String[]{plural, elementsNames});
        } else if (allocationSelectionType == AllocationSelectionType.PHYSICAL_PART_DEPLOYMENT) {
            result = NLS.bind((String)Messages.Allocation_PhysicalComponents_Selection_Message, (Object[])new String[]{plural, elementsNames});
        } else if (allocationSelectionType == AllocationSelectionType.FUNCTIONAL_EXCHANGE_ALLOCATION) {
            result = NLS.bind((String)Messages.Allocation_FunctionalExchagnes_Selection_Message, (Object[])new String[]{plural, elementsNames});
        } else if (allocationSelectionType == AllocationSelectionType.COMPONENT_EXCHANGE_ALLOCATION) {
            result = NLS.bind((String)Messages.Allocation_ComponentExchagnes_Selection_Message, (Object[])new String[]{plural, elementsNames});
        }
        return result;
    }

    private void setDataMessage(String dataMessage) {
        this._dataMessage = dataMessage;
    }

    public String getDataMessage() {
        return this._dataMessage;
    }

    public AllocationSelectionType getAllocationType() {
        return this._allocationType;
    }

    private void setAllocationType(AllocationSelectionType dataType) {
        this._allocationType = dataType;
    }

    public String getPluralString(List<EObject> element, boolean withVerb) {
        String plural = "s";
        return element.size() > 1 ? plural : "";
    }

    private String getElementsNames(List<EObject> element) {
        String elementsNames = "";
        Iterator<EObject> iterator = element.iterator();
        while (iterator.hasNext()) {
            EObject eObject = iterator.next();
            if (eObject instanceof NamedElement) {
                elementsNames = String.valueOf(elementsNames) + ((NamedElement)eObject).getName();
            }
            if (!iterator.hasNext()) continue;
            elementsNames = String.valueOf(elementsNames) + ',' + ' ';
        }
        return elementsNames;
    }

    public boolean isSourceDataVoid() {
        return this._sourceDataVoid;
    }

    private void setSourceDataVoid(boolean sourceDataVoid) {
        this._sourceDataVoid = sourceDataVoid;
    }

    public static enum AllocationSelectionType {
        NONE,
        FUNCTION_ALLOCATION,
        EXCHANGE_ITEM_ALLOCATION,
        PHYSICAL_PART_DEPLOYMENT,
        FUNCTIONAL_EXCHANGE_ALLOCATION,
        COMPONENT_EXCHANGE_ALLOCATION;

    }
}

