/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.match;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.ui.search.match.SearchMatch;
import org.polarsys.capella.core.ui.search.match.SearchMatchChild;

public class ListElementSearchMatchChild
extends SearchMatchChild {
    private int index;

    public ListElementSearchMatchChild(Object source, String text, IProject project, SearchMatch parent, int index) {
        super(source, text, project, parent);
        this.index = index;
    }

    @Override
    public boolean replace(Pattern searchPattern, String replacement) {
        String oldLine = this.getOriginalText();
        final String newContent = searchPattern.matcher(oldLine).replaceAll(replacement);
        if (this.getParent().getAttribute() instanceof EAttribute && this.getParent().getElement() instanceof EObject) {
            final EAttribute matchEntryAttribute = (EAttribute)this.getParent().getAttribute();
            final EObject matchEntryElement = (EObject)this.getParent().getElement();
            if (matchEntryElement.eGet((EStructuralFeature)matchEntryAttribute) instanceof List) {
                TransactionHelper.getExecutionManager((EObject)matchEntryElement).execute((ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        List lineMatches = (List)matchEntryElement.eGet((EStructuralFeature)matchEntryAttribute);
                        lineMatches.remove(ListElementSearchMatchChild.this.index);
                        lineMatches.add(ListElementSearchMatchChild.this.index, newContent);
                    }
                });
                this.setOriginalText(newContent);
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.index);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ListElementSearchMatchChild)) {
            return false;
        }
        ListElementSearchMatchChild other = (ListElementSearchMatchChild)((Object)obj);
        return this.index == other.index;
    }
}

