/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.ui.search.Activator;
import org.polarsys.capella.core.ui.search.CapellaSearchQuery;
import org.polarsys.capella.core.ui.search.match.SearchMatch;
import org.polarsys.capella.core.ui.search.match.SearchMatchChild;

public class CapellaSearchResult
extends AbstractTextSearchResult {
    private CapellaSearchQuery capellaSearchQuery;
    private TreeData treeData;

    public CapellaSearchResult(CapellaSearchQuery capellaSearchQuery) {
        this.capellaSearchQuery = capellaSearchQuery;
        this.setActiveMatchFilters(new MatchFilter[0]);
        this.treeData = new TreeData(new ArrayList(), null){

            protected Object doGetParent(Object element) {
                if (element instanceof DRepresentationDescriptor) {
                    return ((DRepresentationDescriptor)element).getTarget();
                }
                if (element instanceof Shape) {
                    Diagram diagram = ((Shape)element).getDiagram();
                    EObject elt = diagram.getElement();
                    if (elt instanceof DDiagram) {
                        return RepresentationHelper.getRepresentationDescriptor((DRepresentation)((DDiagram)elt));
                    }
                } else if (element instanceof SearchMatchChild) {
                    return ((SearchMatchChild)((Object)element)).getParent();
                }
                return super.doGetParent(element);
            }

            public Object[] getChildren(Object element) {
                if (element instanceof SearchMatch) {
                    return ((SearchMatch)((Object)element)).getChildren().toArray();
                }
                return super.getChildren(element);
            }
        };
    }

    public String getLabel() {
        int totalOccurrenceCount = this.getOccurrenceCount();
        int matchedElementsCount = this.getElements().length;
        int matchedProjectsCount = this.getProjects().size();
        String queryLabel = this.capellaSearchQuery.getLabel();
        int activeFilterCount = this.getActiveMatchFilters().length;
        if (activeFilterCount == 0) {
            return String.format("'%s' - %d occurrence(s) in %d element(s) of %d project(s)", queryLabel, totalOccurrenceCount, matchedElementsCount, matchedProjectsCount);
        }
        int displayedOccurrenceCount = this.getOccurrenceCount();
        return String.format("'%s' - %d occurrence(s) in %d element(s) of %d project(s) - %d occurrence(s) filtered by %d active filter(s)", queryLabel, totalOccurrenceCount, matchedElementsCount, matchedProjectsCount, totalOccurrenceCount - displayedOccurrenceCount, activeFilterCount);
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return Activator.getDefault().getImageDescriptor("search.gif");
    }

    public CapellaSearchQuery getQuery() {
        return this.capellaSearchQuery;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return null;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    public Set<IProject> getProjects() {
        return this.getCapellaSearchMatchesStream().map(SearchMatch::getProject).collect(Collectors.toSet());
    }

    public int getOccurrenceCount() {
        int count = 0;
        Set searchMatches = this.getCapellaSearchMatchesStream().filter(match -> !(match instanceof SearchMatchChild)).collect(Collectors.toSet());
        for (SearchMatch searchMatch : searchMatches) {
            List<SearchMatchChild> children = searchMatch.getChildren();
            count += children.isEmpty() ? 1 : children.size();
        }
        return count;
    }

    private Stream<SearchMatch> getCapellaSearchMatchesStream() {
        return Stream.of(this.getElements()).flatMap(e -> Stream.of(this.getMatches(e))).filter(SearchMatch.class::isInstance).map(SearchMatch.class::cast);
    }

    public Set<SearchMatch> getDisplayedMatches() {
        return this.getCapellaSearchMatchesStream().collect(Collectors.toSet());
    }

    public Set<SearchMatch> getDisplayedMatches(Object element) {
        if (element == null) {
            return Collections.emptySet();
        }
        return this.getCapellaSearchMatchesStream().filter(m -> element.equals(m.getElement())).collect(Collectors.toSet());
    }

    public TreeData getTreeData() {
        return this.treeData;
    }

    public List<SearchMatch> getCapellaEntryMatches(Object element) {
        return Arrays.asList(this.getMatches(element)).stream().filter(e -> e.getClass().equals(SearchMatch.class)).map(SearchMatch.class::cast).collect(Collectors.toList());
    }
}

