/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.utils.saxparser.SaxParserHelper;
import org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram.LinkDescription;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.ILinkParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class DescriptionLinkParserHandler
extends DefaultHandler {
    private ILinkParser linkParserHandler;
    private final EObject element;
    private final IValidationContext ctx;
    protected Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");
    protected StringBuilder desc = null;

    public DescriptionLinkParserHandler(EObject element, IValidationContext ctx, ILinkParser linkParserHandler) {
        this.element = element;
        this.ctx = ctx;
        this.linkParserHandler = linkParserHandler;
    }

    public static String extractName(String statusMessage) {
        String pattern = "with label \"(.*?)\"";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(statusMessage);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public List<IStatus> process(String description) {
        ArrayList<IStatus> exceptions = new ArrayList<IStatus>();
        if (description != null && !description.isEmpty()) {
            description = SaxParserHelper.escapeSpecialCharacter((String)description);
            this.desc = new StringBuilder();
            this.desc.append("<rootSAX>");
            this.desc.append(description);
            this.desc.append("</rootSAX>");
            SAXParser saxParser = null;
            StringReader reader = null;
            try {
                try {
                    SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                    saxFactory.setValidating(false);
                    saxParser = saxFactory.newSAXParser();
                    saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                    LinkParserHandler handler = new LinkParserHandler();
                    InputSource is = new InputSource();
                    reader = new StringReader(this.desc.toString());
                    is.setCharacterStream(reader);
                    saxParser.parse(is, (DefaultHandler)handler);
                }
                catch (SAXParseException ex) {
                    exceptions.add(this.ctx.createFailureStatus(new Object[]{"Invalid description format at line " + ex.getLineNumber()}));
                    if (reader != null && saxParser != null) {
                        reader.close();
                        saxParser.reset();
                    }
                }
                catch (Exception exception_p) {
                    StringBuilder loggerMessage = new StringBuilder("Invalid description format");
                    this.logger.debug((Object)loggerMessage.toString(), (Throwable)exception_p);
                    if (reader != null && saxParser != null) {
                        reader.close();
                        saxParser.reset();
                    }
                }
            }
            finally {
                if (reader != null && saxParser != null) {
                    reader.close();
                    saxParser.reset();
                }
            }
        }
        return exceptions;
    }

    private class LinkParserHandler
    extends DefaultHandler {
        private EObject currentTargetElement;
        private String currentLinkHref;
        private StringBuilder currentLinkContent = new StringBuilder();

        private LinkParserHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("a")) {
                this.currentLinkContent = new StringBuilder(0);
                this.currentLinkHref = "";
                this.currentTargetElement = null;
                int i = 0;
                while (i < attributes.getLength()) {
                    String attValue = attributes.getValue(i);
                    String attName = attributes.getQName(i);
                    if (attValue != null && !attValue.isEmpty() && qName.equalsIgnoreCase("a") && attName.equalsIgnoreCase("href")) {
                        EObject eObject = SaxParserHelper.getEObjectFromHrefAttribute((EObject)DescriptionLinkParserHandler.this.element, (String)attValue);
                        this.currentLinkHref = attValue;
                        if (eObject != null) {
                            this.currentTargetElement = eObject;
                            break;
                        }
                    }
                    ++i;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String string = new String(ch, start, length);
            this.currentLinkContent.append(string);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("a")) {
                String formattedLinkContent = this.currentLinkContent.toString();
                formattedLinkContent = formattedLinkContent.replaceAll("\\s+", " ");
                LinkDescription parsedLink = new LinkDescription(formattedLinkContent, this.currentLinkHref, this.currentTargetElement, new AttributesImpl());
                DescriptionLinkParserHandler.this.linkParserHandler.handleParsedLink(parsedLink);
                this.currentTargetElement = null;
                this.currentLinkContent = new StringBuilder();
                this.currentLinkHref = "";
            }
        }
    }
}

