/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.model.utils.saxparser.SaxParserHelper;
import org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram.LinkDescription;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.DescriptionParserHelper;
import org.polarsys.capella.core.platform.sirius.sirius.validation.parser.helper.ILinkParser;
import org.polarsys.kitalpha.richtext.widget.tools.utils.MDERichTextToolsHelper;

public class InvalidNameHandler
implements ILinkParser {
    private EObject element;
    private IValidationContext ctx;
    private List<IStatus> result = new ArrayList<IStatus>();
    private List<LinkDescription> parsedLinks = new ArrayList<LinkDescription>();

    public InvalidNameHandler(EObject element, IValidationContext ctx) {
        this.element = element;
        this.ctx = ctx;
    }

    public List<IStatus> getResult() {
        return this.result;
    }

    @Override
    public void handleParsedLink(LinkDescription parsedLink) {
        if (parsedLink.getTargetElement() != null && parsedLink.getHref().startsWith("hlink://")) {
            EObject elementFound = parsedLink.getTargetElement();
            boolean isDiagram = elementFound instanceof DRepresentationDescriptor || elementFound instanceof DRepresentation;
            String name = DescriptionParserHelper.getElementName(elementFound);
            String value = MDERichTextToolsHelper.decodeWhiteSpaces((String)parsedLink.getName());
            value = StringEscapeUtils.unescapeHtml((String)value);
            String elementId = parsedLink.getHref().replace("hlink://", "");
            IConstraintDescriptor desc = ConstraintRegistry.getInstance().getDescriptor(this.ctx.getCurrentConstraintId());
            if (!name.equals(value)) {
                if (!this.parsedLinks.contains(parsedLink)) {
                    this.parsedLinks.add(parsedLink);
                    String message = "(Hyperlink) The " + (isDiagram ? "diagram" : "model") + " element named \"" + value + "\" (id: " + elementId + ") found in the rich text description of " + DescriptionParserHelper.getElementName(this.element) + " is not up to date.";
                    message = SaxParserHelper.unescapeSpecialCharacter((String)message);
                    this.result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)this.element, (Collection)this.ctx.getResultLocus(), (int)2, (int)desc.getStatusCode(), (String)"{0}", (Object[])new Object[]{message}));
                } else {
                    String elementName = value;
                    List updatedResult = this.result.stream().map(sts -> {
                        if (sts.getMessage().contains(elementId)) {
                            String message = "(Hyperlink) The " + (isDiagram ? "diagrams" : "models") + " elements named \"" + elementName + ", ...\" (id: " + elementId + ") found in the rich text description of " + DescriptionParserHelper.getElementName(this.element) + " are not up to date.";
                            message = SaxParserHelper.unescapeSpecialCharacter((String)message);
                            return ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)this.element, (Collection)this.ctx.getResultLocus(), (int)2, (int)desc.getStatusCode(), (String)"{0}", (Object[])new Object[]{message});
                        }
                        return sts;
                    }).collect(Collectors.toList());
                    this.result.clear();
                    this.result.addAll(updatedResult);
                }
            }
        }
    }
}

