/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.sections;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlyListener;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.controllers.DAnnotationReferenceController;
import org.polarsys.capella.core.ui.properties.controllers.EOIController;
import org.polarsys.capella.core.ui.properties.controllers.RepresentationContextualElementsController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;
import org.polarsys.capella.core.ui.properties.fields.RepresentationContextualElementsField;
import org.polarsys.capella.core.ui.properties.fields.TextValueGroup;
import org.polarsys.capella.core.ui.properties.providers.CapellaTransfertViewerLabelProvider;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.core.ui.properties.sections.Messages;
import org.polarsys.capella.core.ui.toolkit.helpers.SelectionDialogHelper;

public class DiagramRepresentationPropertySection
extends AbstractSection {
    private WeakReference<DRepresentationDescriptor> _descriptor;
    private Text _nameTextField;
    private FocusAdapter _focusAdapter;
    private KeyAdapter _keyAdapter;
    private RepresentationContextualElementsField _contextualElementsField;
    private MultipleSemanticField _eoiField;
    private TextValueGroup packageGroup;

    protected void commitNameChanged() {
        if (this._descriptor.get() == null || this._nameTextField.getText().equals(((DRepresentationDescriptor)this._descriptor.get()).getName())) {
            return;
        }
        this.executeCommmand((ICommand)new AbstractReadWriteCommand(){

            public Collection<?> getAffectedObjects() {
                return Collections.singleton(DiagramRepresentationPropertySection.this._descriptor);
            }

            public String getName() {
                return Messages.RepresentationSection_SetCommand_Representation_Name_Label;
            }

            public void run() {
                ((DRepresentationDescriptor)DiagramRepresentationPropertySection.this._descriptor.get()).setName(DiagramRepresentationPropertySection.this._nameTextField.getText());
            }
        });
    }

    @Override
    protected int getColumnCount() {
        return 1;
    }

    @Override
    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
        TabbedPropertySheetWidgetFactory widgetFactory = this.getWidgetFactory();
        Group textGroup = widgetFactory.createGroup(parent, "");
        textGroup.setLayout((Layout)new GridLayout(2, false));
        textGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this._focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (e.widget == DiagramRepresentationPropertySection.this._nameTextField) {
                    DiagramRepresentationPropertySection.this.commitNameChanged();
                }
            }
        };
        this._keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event != null && event.character == '\r' && event.widget == DiagramRepresentationPropertySection.this._nameTextField) {
                    DiagramRepresentationPropertySection.this.commitNameChanged();
                }
            }
        };
        this.createNameWidget(widgetFactory, textGroup);
        this.createPackageWidget(widgetFactory, (Composite)textGroup);
        this.createContextualElementsWidget(widgetFactory, parent);
        this.createEOIWidget(widgetFactory, parent);
    }

    protected void createNameWidget(TabbedPropertySheetWidgetFactory widgetFactory, Group textGroup) {
        widgetFactory.createCLabel((Composite)textGroup, Messages.RepresentationSection_Name_Title);
        this._nameTextField = widgetFactory.createText((Composite)textGroup, "");
        this._nameTextField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this._nameTextField.addFocusListener((FocusListener)this._focusAdapter);
        this._nameTextField.addKeyListener((KeyListener)this._keyAdapter);
    }

    protected void createContextualElementsWidget(TabbedPropertySheetWidgetFactory widgetFactory, Composite rootParentComposite) {
        boolean displayedInWizard = this.isDisplayedInWizard();
        this._contextualElementsField = new RepresentationContextualElementsField((Composite)this.getReferencesGroup(), Messages.ContextualElements_Label, this.getWidgetFactory(), new RepresentationContextualElementsController());
        this._contextualElementsField.setDisplayedInWizard(displayedInWizard);
    }

    protected void createEOIWidget(TabbedPropertySheetWidgetFactory widgetFactory, Composite rootParentComposite) {
        this._eoiField = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.EOI_label, widgetFactory, new EOIController()){

            @Override
            protected void doDeleteCommand(EObject element, EStructuralFeature feature) {
                ((DAnnotationReferenceController)this._controller).clear(element);
                if (this._valueEditBtn != null) {
                    this._valueEditBtn.setEnabled(true);
                }
                this.setValueTextField(null);
            }

            @Override
            protected List<EObject> openTransferDialog(Button button, List<EObject> currentElements, List<EObject> availableElements, String title, String message) {
                CapellaTransfertViewerLabelProvider leftLabelProvider = new CapellaTransfertViewerLabelProvider();
                CapellaTransfertViewerLabelProvider rightLabelProvider = new CapellaTransfertViewerLabelProvider();
                boolean expandLeftViewer = CapellaUIPropertiesPlugin.getDefault().isAllowedExpandLeftViewerContent();
                boolean expandRightViewer = CapellaUIPropertiesPlugin.getDefault().isAllowedExpandRightViewerContent();
                return SelectionDialogHelper.multiplePropertyTransfertDialogWizard((Shell)button.getShell(), (String)((DRepresentationDescriptor)this.semanticElement).getName(), (String)Messages.EOI_dialogMessage, availableElements, currentElements, (DataLabelProvider)leftLabelProvider, (DataLabelProvider)rightLabelProvider, (int)(expandLeftViewer ? 2 : 0), (int)(expandRightViewer ? -1 : 0));
            }
        };
        this._eoiField.setDisplayedInWizard(this.isDisplayedInWizard());
    }

    protected void createPackageWidget(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        this.packageGroup = new TextValueGroup(parent, Messages.Package_label, widgetFactory, true){

            @Override
            protected void createValueTextField(String label, boolean hasResetBtn) {
                this.widgetFactory.createCLabel(this.parent, label);
                this.valueField = this.widgetFactory.createText(this.parent, "");
                GridData gd = new GridData(768);
                gd.heightHint = 20;
                gd.widthHint = 150;
                this.valueField.setLayoutData((Object)gd);
                this.addListeners();
            }

            @Override
            public void loadTextValue() {
                String name = DiagramHelper.getService().getPackageName((DRepresentationDescriptor)this.semanticElement);
                this.valueField.setText(name == null ? "" : name);
                this.updateResetBtnStatus();
            }

            @Override
            protected void setDataValue(EObject object, EStructuralFeature feature, Object value) {
                Command c;
                TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)object);
                String newName = ((String)value).trim();
                if (newName.isEmpty()) {
                    newName = null;
                }
                if ((c = DiagramHelper.getService().createSetPackageNameCommand(domain, (DRepresentationDescriptor)object, newName)) != null && c.canExecute()) {
                    domain.getCommandStack().execute(c);
                }
            }
        };
        this.packageGroup.setDisplayedInWizard(this.isDisplayedInWizard());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._descriptor != null) {
            CapellaReadOnlyHelper.unregister((EObject)((EObject)this._descriptor.get()), (IReadOnlyListener)this);
            this._descriptor.clear();
            this._descriptor = null;
        }
    }

    @Override
    public void historyNotification(OperationHistoryEvent event) {
        Command command;
        IUndoableOperation operation;
        int eventType = event.getEventType();
        if ((10 == eventType || 9 == eventType) && (operation = event.getOperation()) instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()).getAffectedObjects().contains(this._descriptor)) {
            this.refresh();
        }
    }

    protected void loadData() {
        String name = "";
        boolean isContextual = false;
        if (this._descriptor != null) {
            name = ((DRepresentationDescriptor)this._descriptor.get()).getName();
            this._eoiField.loadData((EObject)this._descriptor.get());
            this.packageGroup.loadData((EObject)this._descriptor.get(), null);
            if (this._contextualElementsField != null) {
                isContextual = ContextualDiagramHelper.getService().isContextualRepresentation((DRepresentationDescriptor)this._descriptor.get());
                this._contextualElementsField.loadData((DRepresentationDescriptor)this._descriptor.get());
            }
        }
        if (this._contextualElementsField != null) {
            this._contextualElementsField.setEnabled(isContextual);
        }
        this._nameTextField.setText(name);
    }

    @Override
    public void refresh() {
        this.loadData();
    }

    @Override
    public boolean select(Object toTest) {
        return toTest instanceof DRepresentationDescriptor || toTest instanceof DRepresentation || toTest instanceof IDDiagramEditPart;
    }

    @Override
    protected ExecutionManager getExecutionManager() {
        return TransactionHelper.getExecutionManager((EObject)((EObject)this._descriptor.get()));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (!selection.isEmpty()) {
            if (this._descriptor != null) {
                CapellaReadOnlyHelper.unregister((EObject)((EObject)this._descriptor.get()), (IReadOnlyListener)this);
            }
            if (selection instanceof IStructuredSelection) {
                IDDiagramEditPart diagramEditPart;
                Diagram gmfDiagram;
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof IDDiagramEditPart && (gmfDiagram = (Diagram)(diagramEditPart = (IDDiagramEditPart)firstElement).getModel()) != null) {
                    firstElement = (DRepresentation)gmfDiagram.getElement();
                }
                if (firstElement instanceof DRepresentation) {
                    firstElement = RepresentationHelper.getRepresentationDescriptor((DRepresentation)((DRepresentation)firstElement));
                }
                this._descriptor = firstElement instanceof DRepresentationDescriptor ? new WeakReference<DRepresentationDescriptor>((DRepresentationDescriptor)firstElement) : null;
            }
            this.loadData();
            if (this._descriptor != null) {
                this.register((EObject)this._descriptor.get());
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._nameTextField != null && !this._nameTextField.isDisposed()) {
            this._nameTextField.setEnabled(enabled);
        }
        if (this._contextualElementsField != null) {
            this._contextualElementsField.setEnabled(enabled);
        }
    }

    @Override
    public List<AbstractSemanticField> getSemanticFields() {
        return Arrays.asList(this._eoiField, this.packageGroup);
    }
}

