/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.capellacommon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class GetAvailable_AbstractStateProperties
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement inputElement = (CapellaElement)input;
        ArrayList<Object> availableElements = new ArrayList<Object>();
        BlockArchitecture arch = SystemEngineeringExt.getRootBlockArchitecture((ModelElement)inputElement);
        if (arch != null) {
            for (BlockArchitecture block : BlockArchitectureExt.getAllAllocatedArchitectures((BlockArchitecture)arch)) {
                TreeIterator allContents = EcoreUtil.getAllContents((EObject)block, (boolean)false);
                while (allContents.hasNext()) {
                    Object object = allContents.next();
                    if (!(object instanceof ExchangeItem) && !(object instanceof Operation)) continue;
                    availableElements.add(object);
                }
            }
            EObject eContainer = inputElement.eContainer();
            while (!(eContainer == null || eContainer instanceof Component || eContainer instanceof ComponentPkg || eContainer instanceof Class)) {
                eContainer = eContainer.eContainer();
            }
            if (eContainer instanceof ComponentPkg && inputElement instanceof State) {
                for (Component component : ComponentPkgExt.getSubDefinedComponents((ComponentPkg)((ComponentPkg)eContainer))) {
                    availableElements.addAll(this.getElementsFromComponentAndSubComponents(component));
                }
            }
            if (eContainer instanceof Component && inputElement instanceof State) {
                availableElements.addAll(this.getElementsFromComponentAndSubComponents((Component)eContainer));
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getElementsFromComponentAndSubComponents(Component component) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        List subComponents = ComponentExt.getAllSubUsedAndDeployedComponents((Component)component);
        subComponents.add(component);
        for (Component cpnt : subComponents) {
            availableElements.addAll((Collection<CapellaElement>)cpnt.getAllocatedFunctions());
        }
        return availableElements;
    }
}

