/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Unit;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class GetAvailable_NumericValue_Unit
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        List<Object> availableElements = new ArrayList<EObject>();
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)element);
        if (systemEngineering == null) {
            return availableElements;
        }
        if (element instanceof NumericValue) {
            NumericValue currentNumericValue = (NumericValue)element;
            availableElements.addAll(this.getRule_MQRY_NumericValue_Unit_11(currentNumericValue));
            availableElements.addAll(this.getRule_MQRY_NumericValue_Unit_12(currentNumericValue));
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_NumericValue_Unit_11(NumericValue currentNumericValue) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        EObject container = currentNumericValue.eContainer();
        while (container != null) {
            DataPkg componentDataPkg;
            if (container instanceof Component && (componentDataPkg = ((Component)container).getOwnedDataPkg()) != null) {
                for (Unit u : DataPkgExt.getAllUnits((DataPkg)((Component)container).getOwnedDataPkg())) {
                    availableElements.add((CapellaElement)u);
                }
            }
            container = container.eContainer();
        }
        BlockArchitecture arch = DataPkgExt.getRootBlockArchitecture((ModelElement)currentNumericValue);
        availableElements.addAll(this.getElementsFromBlockArchitecture(arch, currentNumericValue.getUnit()));
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_NumericValue_Unit_12(NumericValue currentNumericValue) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        EObject container = currentNumericValue.eContainer();
        if (container instanceof DataPkg) {
            List dataPkgList = DataPkgExt.getDataPkgsFromParentHierarchy((DataPkg)((DataPkg)container));
            for (DataPkg dataPkg : dataPkgList) {
                if (dataPkg == null) continue;
                for (Unit unit : DataPkgExt.getAllUnits((DataPkg)dataPkg)) {
                    availableElements.add((CapellaElement)unit);
                }
            }
        }
        availableElements.addAll(this.getRule_MQRY_NumericValue_Unit_12_1(currentNumericValue));
        return availableElements;
    }

    private List<CapellaElement> getElementsFromBlockArchitecture(BlockArchitecture arch, Unit link) {
        DataPkg dataPkg;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        if (arch != null && (dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture((BlockArchitecture)arch)) != null) {
            for (Unit unit : DataPkgExt.getAllUnits((DataPkg)dataPkg)) {
                availableElements.add((CapellaElement)unit);
            }
        }
        return availableElements;
    }

    private List<CapellaElement> getRule_MQRY_NumericValue_Unit_12_1(NumericValue currentNumericValue) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        BlockArchitecture arch = DataPkgExt.getRootBlockArchitecture((ModelElement)currentNumericValue);
        SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)currentNumericValue);
        OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering);
        if (oa != null) {
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)oa, currentNumericValue.getUnit()));
        } else {
            SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
            availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ca, currentNumericValue.getUnit()));
        }
        if (arch != null) {
            if (oa != null && arch instanceof LogicalArchitecture || arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                SystemAnalysis ctxArch = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)ctxArch, currentNumericValue.getUnit()));
            }
            if (arch instanceof PhysicalArchitecture || arch instanceof EPBSArchitecture) {
                LogicalArchitecture logArch = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)logArch, currentNumericValue.getUnit()));
            }
            if (arch instanceof EPBSArchitecture) {
                PhysicalArchitecture physArch = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering);
                availableElements.addAll(this.getElementsFromBlockArchitecture((BlockArchitecture)physArch, currentNumericValue.getUnit()));
            }
        }
        return availableElements;
    }
}

