/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ControlNodeKind implements Enumerator
{
    OR(0, "OR", "OR"),
    AND(1, "AND", "AND"),
    ITERATE(2, "ITERATE", "ITERATE");

    public static final int OR_VALUE = 0;
    public static final int AND_VALUE = 1;
    public static final int ITERATE_VALUE = 2;
    private static final ControlNodeKind[] VALUES_ARRAY;
    public static final List<ControlNodeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ControlNodeKind[]{OR, AND, ITERATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ControlNodeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControlNodeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ControlNodeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControlNodeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ControlNodeKind get(int value) {
        switch (value) {
            case 0: {
                return OR;
            }
            case 1: {
                return AND;
            }
            case 2: {
                return ITERATE;
            }
        }
        return null;
    }

    private ControlNodeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

