/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.actions.AbstractModelBasedAction;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.AbstractHighlightAllPatternsInstancesPanelDialog;
import org.eclipse.emf.diffmerge.patterns.ui.util.PatternsInstancesUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class HighlightAllPatternsInstancesAction
extends AbstractModelBasedAction {
    protected Object _diagram;

    @Override
    protected void coreRun(List<Object> selection_p) {
        if (!selection_p.isEmpty() && selection_p.get(0) instanceof EObject) {
            this._diagram = this.getDiagramFromSelection(this.getSelection());
            Set<IPatternInstance> instances = this.getPresentInstances(this._diagram, (EObject)selection_p.get(0), this.getShell());
            if (instances != null) {
                if (instances.isEmpty()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.HighlightAllPatternsInstancesAction_NoElementInInstance);
                } else {
                    Object context = selection_p.get(0);
                    EditingDomain domain = null;
                    if (context instanceof IFile) {
                        domain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain((IFile)context);
                    } else if (context instanceof EObject) {
                        domain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain((EObject)context);
                    }
                    if (domain != null) {
                        AbstractHighlightAllPatternsInstancesPanelDialog dialog = this.instantiateHighlightAllPatternsInstancesPanelDialog(instances, selection_p);
                        dialog.open();
                    }
                }
            }
        }
    }

    protected Set<IPatternInstance> getPresentInstances(Object graphicalContext_p, EObject element_p, Shell shell_p) {
        HashSet<IPatternInstance> instances = new HashSet<IPatternInstance>();
        IPatternSupport support = null;
        if (this._genericTypeUtil.isInstanceOfDiagramType(graphicalContext_p)) {
            if (element_p != null) {
                support = CorePatternsPlugin.getDefault().getPatternSupportFor(element_p);
            }
            if (support == null) {
                PatternsInstancesUIUtil.informNoPatternSupport(shell_p);
            } else if (this._genericTypeUtil.isInstanceOfSemanticRepresentationType(graphicalContext_p)) {
                instances.addAll(this.getIncludedPatternInstances(support, graphicalContext_p));
            }
        }
        return instances;
    }

    private Set<IPatternInstance> getIncludedPatternInstances(IPatternSupport support_p, Object semanticDecorator_p) {
        HashSet<IPatternInstance> res;
        block4: {
            block3: {
                res = new HashSet<IPatternInstance>();
                List currentElementInstances = support_p.getRelatedInstances(this._diagramUtil.getSemanticRepresentationTypeTarget(semanticDecorator_p));
                if (!currentElementInstances.isEmpty()) {
                    res.addAll(currentElementInstances);
                }
                if (!this._genericTypeUtil.isInstanceOfDiagramType(semanticDecorator_p)) break block3;
                for (Object part : this._diagramUtil.getDiagramElements(semanticDecorator_p)) {
                    res.addAll(this.getIncludedPatternInstances(support_p, part));
                }
                break block4;
            }
            if (!this._genericTypeUtil.isInstanceOfGraphicalNodeContainerType(semanticDecorator_p)) break block4;
            for (Object part : this._diagramUtil.getOwnedDiagramElements(semanticDecorator_p)) {
                if (!this._genericTypeUtil.isInstanceOfSemanticRepresentationType(part)) continue;
                res.addAll(this.getIncludedPatternInstances(support_p, part));
            }
        }
        return res;
    }

    protected Object getDiagramFromSelection(IStructuredSelection selection_p) {
        return this._diagramUtil.getDiagramFromSelection(Arrays.asList(selection_p.toArray()));
    }

    protected AbstractHighlightAllPatternsInstancesPanelDialog instantiateHighlightAllPatternsInstancesPanelDialog(Set<IPatternInstance> instances_p, List<Object> selection_p) {
        return this._dialogAndWizardFactory.instantiateHighlightAllPatternsInstancesPanelDialog(instances_p, selection_p, this._diagram, this.getShell(), Messages.HighlightAllPatternsInstances_DialogTitle, Messages.HighlightAllPatternsInstances_DialogMessage);
    }
}

