/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternApplicationScope;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.AbstractElementSelectionDialog;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ElementInclusionDialog
extends AbstractElementSelectionDialog<Collection<EObject>> {
    protected final ITreeDataScope<EObject> _scope;
    protected final Collection<? extends EObject> _initialSelection;

    public ElementInclusionDialog(Shell parentShell_p, String message_p, EObject context_p, Collection<? extends EObject> initialSelection_p, ITreeDataScope<EObject> scope_p) {
        this(parentShell_p, message_p, ElementInclusionDialog.getRelevantElements(context_p), initialSelection_p, scope_p);
    }

    protected static List<EObject> getRelevantElements(EObject context_p) {
        FArrayList result = new FArrayList();
        ISemanticRuleProvider ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor((Object)context_p);
        Collection<Object> roots = ruleProvider == null ? Collections.singleton(EcoreUtil.getRootContainer((EObject)context_p)) : ruleProvider.getRootsForPatternInclusion(context_p);
        TemplatePatternApplicationScope.PatternInstanceMarkerFilter filter = new TemplatePatternApplicationScope.PatternInstanceMarkerFilter();
        if (roots != null) {
            for (EObject eObject : roots) {
                if (!filter.accepts(eObject)) continue;
                result.add(eObject);
                TreeIterator it = eObject.eAllContents();
                while (it.hasNext()) {
                    EObject current = (EObject)it.next();
                    if (filter.accepts(current)) {
                        result.add(current);
                        continue;
                    }
                    it.prune();
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    public ElementInclusionDialog(Shell parentShell_p, String message_p, Collection<? extends EObject> candidates_p, Collection<? extends EObject> initialSelection_p, ITreeDataScope<EObject> scope_p) {
        super(parentShell_p, message_p == null ? Messages.ElementInclusionDialog_Prompt : message_p, candidates_p);
        this._initialSelection = initialSelection_p;
        this._scope = scope_p;
    }

    protected Control createContents(Composite parent_p) {
        Control result = super.createContents(parent_p);
        this._viewer.select(this._initialSelection.toArray());
        return result;
    }

    @Override
    public Collection<EObject> getChoice() {
        return this._viewer.getChoices();
    }

    @Override
    protected ModelSubsetViewer getChoiceViewer(Composite parent_p) {
        ModelSubsetViewer result = new ModelSubsetViewer(parent_p, true, true);
        result.setInput(this._candidates);
        return result;
    }

    @Override
    protected boolean initiallySelectFirst() {
        return false;
    }

    @Override
    protected boolean isEligible(EObject element_p) {
        return !this._scope.covers((Object)element_p);
    }
}

