/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplateUsageSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.providers.DiscriminatingLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TemplateUsageDialog
extends MessageDialog {
    public static final Object FAILURE_ELEMENT = new Object();
    public static final Object EMPTY_ELEMENT = new Object();
    private final DetailedTemplateUsageSpecification _data;

    public TemplateUsageDialog(Shell parentShell_p, TemplateUsageSpecification data_p) {
        super(parentShell_p, Messages.TemplateUsageDialog_Title, null, TemplateUsageDialog.getDialogMessage(data_p), 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this._data = new DetailedTemplateUsageSpecification(data_p);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private static String getDialogMessage(TemplateUsageSpecification data_p) {
        return String.format(Messages.TemplateUsageDialog_Message, data_p.getPattern().getName(), DiscriminatingLabelProvider.getInstance().getText(data_p.getTargetElement()));
    }

    public void create() {
        super.create();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    TemplateUsageDialog.this.getData().computeApplication();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createApplicationArea(Composite parent_p) {
        final TreeViewer treeViewer = new TreeViewer(parent_p);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){
            private IPatternApplication _application;

            public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
                this._application = (IPatternApplication)newInput_p;
            }

            public void dispose() {
                this._application = null;
            }

            public boolean hasChildren(Object element_p) {
                return this.getChildren(element_p).length > 0;
            }

            public Object getParent(Object element_p) {
                return null;
            }

            public Object[] getElements(Object inputElement_p) {
                Object[] result = new Object[]{};
                if (inputElement_p instanceof IPatternApplication) {
                    result = ((IPatternApplication)inputElement_p).getPattern().getRoles().toArray();
                }
                return result;
            }

            public Object[] getChildren(Object parentElement_p) {
                Object[] result = new Object[]{};
                if (parentElement_p instanceof TemplatePatternRole) {
                    TemplatePatternRole role = (TemplatePatternRole)parentElement_p;
                    ILocation location = this._application.getLocation((IPatternRole)role);
                    if (location == null) {
                        result = new Object[]{FAILURE_ELEMENT};
                    } else {
                        result = LocationsUtil.getMergeTargets((ILocation)location).toArray();
                        if (result.length == 0) {
                            result = new Object[]{EMPTY_ELEMENT};
                        }
                    }
                }
                return result;
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)DiscriminatingLabelProvider.getInstance());
        this._data.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("property_application".equals(event_p.getProperty())) {
                    TemplateUsageDialog.this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            treeViewer.setInput((Object)TemplateUsageDialog.this.getData().getApplication());
                        }
                    });
                }
            }
        });
    }

    protected void createConfigurationArea(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createIncludeChildrenCheckBox(composite);
        final Button excludeButton = this.createExcludeElementsCheckBox(composite);
        final Button deleteRolesButton = this.createDeleteRolesCheckBox(composite);
        excludeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                boolean excludeElements = excludeButton.getSelection();
                deleteRolesButton.setEnabled(!excludeElements);
                deleteRolesButton.setSelection(excludeElements || TemplateUsageDialog.this.getData().isDeleteRoles());
            }
        });
        this.createOverridePrimaryCheckBox(composite);
        this.createIncludeEmptyRolesCheckBox(composite);
        this.createIncludeDerivationRulesCheckBox(composite);
    }

    protected Control createCustomArea(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        GridData resultLayoutData = new GridData(4, 4, true, true);
        resultLayoutData.heightHint = 400;
        resultLayoutData.widthHint = 300;
        result.setLayoutData((Object)resultLayoutData);
        result.setLayout((Layout)new GridLayout(1, false));
        this.createApplicationArea(result);
        this.createConfigurationArea(result);
        return result;
    }

    protected Control createContents(Composite parent_p) {
        Control result = super.createContents(parent_p);
        final Button okButton = this.getButton(0);
        okButton.setEnabled(false);
        this._data.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("property_application".equals(event_p.getProperty())) {
                    TemplateUsageDialog.this.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            boolean ok = TemplateUsageDialog.this.getData().isComplete();
                            okButton.setEnabled(ok);
                        }
                    });
                }
            }
        });
        return result;
    }

    protected Button createDeleteRolesCheckBox(Composite parent_p) {
        Button result = new Button(parent_p, 32);
        result.setText(Messages.TemplateUsageDialog_DeleteRoles);
        result.setSelection(this.getData().isExcludeElements() || this.getData().isDeleteRoles());
        result.setEnabled(!this.getData().isExcludeElements());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplateUsageDialog.this.getData().setDeleteRoles(!TemplateUsageDialog.this.getData().isDeleteRoles());
            }
        });
        return result;
    }

    protected Button createExcludeElementsCheckBox(Composite parent_p) {
        Button result = new Button(parent_p, 32);
        result.setText(Messages.TemplateUsageDialog_ExcludeElements);
        result.setSelection(this.getData().isExcludeElements());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplateUsageDialog.this.getData().setExcludeElements(!TemplateUsageDialog.this.getData().isExcludeElements());
            }
        });
        return result;
    }

    protected Button createIncludeChildrenCheckBox(Composite parent_p) {
        Button result = new Button(parent_p, 32);
        result.setText(Messages.TemplateUsageDialog_IncludeChildren);
        result.setSelection(this.getData().isIncludeChildren());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplateUsageDialog.this.getData().setIncludeChildren(!TemplateUsageDialog.this.getData().isIncludeChildren());
            }
        });
        return result;
    }

    protected Button createIncludeEmptyRolesCheckBox(Composite parent_p) {
        Button result = new Button(parent_p, 32);
        result.setText(Messages.TemplateUsageDialog_KeepEmptyRoles);
        result.setSelection(this.getData().isIncludeEmptyRoles());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplateUsageDialog.this.getData().setIncludeEmptyRoles(!TemplateUsageDialog.this.getData().isIncludeEmptyRoles());
            }
        });
        return result;
    }

    protected Button createIncludeDerivationRulesCheckBox(Composite parent_p) {
        Button result = new Button(parent_p, 32);
        result.setText(Messages.TemplateUsageDialog_KeepRules);
        result.setSelection(this.getData().isIncludeTargetDerivationRules());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplateUsageDialog.this.getData().setIncludeTargetDerivationRules(!TemplateUsageDialog.this.getData().isIncludeTargetDerivationRules());
            }
        });
        return result;
    }

    protected Button createOverridePrimaryCheckBox(Composite parent_p) {
        Button result = new Button(parent_p, 32);
        result.setText(Messages.TemplateUsageDialog_OverrideMainRole);
        result.setSelection(this.getData().isOverridePrimaryName() && this.getData().isOverridePrimaryDescription());
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                TemplateUsageDialog.this.getData().setOverridePrimaryName(!TemplateUsageDialog.this.getData().isOverridePrimaryName());
                TemplateUsageDialog.this.getData().setOverridePrimaryDescription(!TemplateUsageDialog.this.getData().isOverridePrimaryDescription());
            }
        });
        return result;
    }

    public DetailedTemplateUsageSpecification getData() {
        return this._data;
    }

    public static class DetailedTemplateUsageSpecification {
        private static final String PROPERTY_APPLICATION = "property_application";
        private final TemplateUsageSpecification _data;
        private IPatternApplication _application;
        private boolean _includeChildren;
        private boolean _deleteRoles;
        private boolean _excludeElements;
        private boolean _overridePrimaryName;
        private boolean _overridePrimaryDescription;
        private boolean _includeEmptyRoles;
        private boolean _includeTargetDerivationRules;
        private final Set<IPropertyChangeListener> _listeners;

        public DetailedTemplateUsageSpecification(TemplateUsageSpecification data_p) {
            this._data = data_p;
            this._application = null;
            this.setIncludeChildren(true);
            this._deleteRoles = true;
            this._excludeElements = true;
            this._overridePrimaryName = true;
            this._overridePrimaryDescription = true;
            this._includeEmptyRoles = false;
            this._includeTargetDerivationRules = false;
            this._listeners = new HashSet<IPropertyChangeListener>();
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
            this._listeners.add(listener_p);
        }

        public void computeApplication() {
            this._application = this._data.computeApplication();
            this.notify(PROPERTY_APPLICATION);
        }

        public void execute() {
            if (this.isComplete()) {
                this._data.execute(this._application, this._includeChildren, this._deleteRoles, this._excludeElements, this._overridePrimaryName, this._overridePrimaryDescription, this._includeEmptyRoles, this._includeTargetDerivationRules);
            }
        }

        public IPatternApplication getApplication() {
            return this._application;
        }

        public boolean isComplete() {
            boolean result;
            boolean bl = result = this._application != null;
            if (result) {
                boolean first = true;
                result = false;
                for (IPatternRole role : this._application.getPattern().getRoles()) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    ILocation location = this._application.getLocation(role);
                    if (location == null) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }

        public boolean isIncludeChildren() {
            return this._includeChildren;
        }

        public void setIncludeChildren(boolean includeChildren_p) {
            this._includeChildren = includeChildren_p;
        }

        public boolean isDeleteRoles() {
            return this._deleteRoles;
        }

        public void setDeleteRoles(boolean deleteRoles_p) {
            this._deleteRoles = deleteRoles_p;
        }

        public boolean isExcludeElements() {
            return this._excludeElements;
        }

        public void setExcludeElements(boolean excludeElements_p) {
            this._excludeElements = excludeElements_p;
        }

        public boolean isOverridePrimaryName() {
            return this._overridePrimaryName;
        }

        public void setOverridePrimaryName(boolean overridePrimaryName_p) {
            this._overridePrimaryName = overridePrimaryName_p;
        }

        public boolean isOverridePrimaryDescription() {
            return this._overridePrimaryDescription;
        }

        public void setOverridePrimaryDescription(boolean overridePrimaryDescription_p) {
            this._overridePrimaryDescription = overridePrimaryDescription_p;
        }

        public boolean isIncludeEmptyRoles() {
            return this._includeEmptyRoles;
        }

        public void setIncludeEmptyRoles(boolean includeEmptyRoles_p) {
            this._includeEmptyRoles = includeEmptyRoles_p;
        }

        public boolean isIncludeTargetDerivationRules() {
            return this._includeTargetDerivationRules;
        }

        public void setIncludeTargetDerivationRules(boolean includeTargetDerivationRules_p) {
            this._includeTargetDerivationRules = includeTargetDerivationRules_p;
        }

        protected void notify(String property_p) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property_p, null, null);
            for (IPropertyChangeListener listener : this._listeners) {
                listener.propertyChange(event);
            }
        }
    }
}

