/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.query;

import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeListCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.NoteEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusNoteEditPart;
import org.eclipse.sirius.ext.base.Option;

public final class EditPartQuery {
    private IGraphicalEditPart editPart;

    public EditPartQuery(IGraphicalEditPart editPart) {
        this.editPart = editPart;
    }

    public DiagramDescription getDiagramDescription() {
        Optional<DDiagram> optionalDDiagram = this.getDDiagram();
        if (optionalDDiagram.isPresent()) {
            return optionalDDiagram.get().getDescription();
        }
        return null;
    }

    public Optional<DDiagram> getDDiagram() {
        Option<DDiagram> ddiagram;
        IDDiagramEditPart effectiveDiagramEditPart = null;
        if (this.editPart instanceof IDiagramElementEditPart || this.editPart instanceof AbstractDNodeContainerCompartmentEditPart || this.editPart instanceof AbstractDNodeListCompartmentEditPart) {
            effectiveDiagramEditPart = this.getDiagramEditPart((EditPart)this.editPart);
        } else if (this.editPart instanceof IDDiagramEditPart) {
            effectiveDiagramEditPart = (IDDiagramEditPart)this.editPart;
        }
        if (effectiveDiagramEditPart != null && (ddiagram = effectiveDiagramEditPart.resolveDDiagram()).some()) {
            return Optional.of((DDiagram)ddiagram.get());
        }
        return Optional.empty();
    }

    public boolean isMovableByAutomaticLayout(List<IDiagramElementEditPart> elementsToNotMove) {
        boolean isMovableByAutomaticLayout = true;
        if (!(this.editPart instanceof SiriusNoteEditPart)) {
            if (this.editPart.resolveSemanticElement() instanceof DDiagramElement) {
                isMovableByAutomaticLayout = !this.isPinned() && (elementsToNotMove == null || !elementsToNotMove.contains(this.editPart));
            }
        } else if (!Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", SiriusDiagramPreferencesKeys.PREF_MOVE_NOTES_DURING_LATOUT.name(), false, null)) {
            isMovableByAutomaticLayout = false;
        } else {
            boolean connectedToPinnedElement = false;
            Iterable filterSourceConnections = () -> this.editPart.getSourceConnections().stream().filter(ConnectionEditPart.class::isInstance).map(ConnectionEditPart.class::cast).iterator();
            for (ConnectionEditPart sourceConn : filterSourceConnections) {
                if (!(sourceConn.getTarget() instanceof IGraphicalEditPart)) continue;
                boolean bl = connectedToPinnedElement = connectedToPinnedElement || !new EditPartQuery((IGraphicalEditPart)sourceConn.getTarget()).isMovableByAutomaticLayout(elementsToNotMove);
            }
            Iterable filterTargetConnections = () -> this.editPart.getTargetConnections().stream().filter(ConnectionEditPart.class::isInstance).map(ConnectionEditPart.class::cast).iterator();
            for (ConnectionEditPart targetConn : filterTargetConnections) {
                if (!(targetConn.getSource() instanceof IGraphicalEditPart)) continue;
                boolean bl = connectedToPinnedElement = connectedToPinnedElement || !new EditPartQuery((IGraphicalEditPart)targetConn.getSource()).isMovableByAutomaticLayout(elementsToNotMove);
            }
            if (connectedToPinnedElement) {
                isMovableByAutomaticLayout = false;
            }
        }
        return isMovableByAutomaticLayout;
    }

    public boolean isANoteLinkedToOtherEditPart() {
        boolean connectedToElement = false;
        if (this.editPart instanceof NoteEditPart) {
            connectedToElement = this.editPart.getSourceConnections().size() > 0 || this.editPart.getTargetConnections().size() > 0;
        }
        return connectedToElement;
    }

    private IDDiagramEditPart getDiagramEditPart(EditPart theEditPart) {
        IDDiagramEditPart result = null;
        EditPart parent = theEditPart.getParent();
        if (parent instanceof IDDiagramEditPart) {
            result = (IDDiagramEditPart)parent;
        } else if (parent != null) {
            result = this.getDiagramEditPart(parent);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isPinned() {
        String prefKey = SiriusDiagramPreferencesKeys.PREF_MOVE_PINNED_ELEMENTS.name();
        boolean ignorePin = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", prefKey, false, null);
        if (ignorePin) {
            return false;
        }
        boolean isPinned = false;
        EObject eObject = this.editPart.resolveSemanticElement();
        if (eObject instanceof DDiagramElement) {
            void dDiagramElement;
            DDiagramElement dDiagramElement2 = (DDiagramElement)eObject;
            DDiagramElement cfr_ignored_0 = (DDiagramElement)eObject;
            isPinned = new PinHelper().isPinned((DDiagramElement)dDiagramElement);
        }
        return isPinned;
    }
}

