/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.ui;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyGroup;
import org.polarsys.capella.common.flexibility.wizards.group.renderer.CTabGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.group.renderer.DefaultGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.group.renderer.FlatGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.policy.AbstractRendererPolicy;
import org.polarsys.capella.common.flexibility.wizards.policy.IPolicifiedRendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderers;

public class PropertyControl {
    protected IPropertyContext _context;
    protected IRendererContext _renderers;
    protected ILabelProvider _labelProvider;

    protected IPropertyContext getPropertyContext() {
        return this._context;
    }

    protected IRendererContext getRendererContext() {
        return this._renderers;
    }

    protected ILabelProvider getLabelProvider() {
        return this._labelProvider;
    }

    protected boolean isFlat() {
        return false;
    }

    public PropertyControl(ILabelProvider labelProvider, IPropertyContext context, IRendererContext renderers) {
        this._context = context;
        this._renderers = renderers;
        this._labelProvider = labelProvider;
        this.initRendererContext();
    }

    protected void initRendererContext() {
        if (this._renderers instanceof IPolicifiedRendererContext) {
            ((IPolicifiedRendererContext)((Object)this._renderers)).addRendererPolicy(new AbstractRendererPolicy(){

                @Override
                public boolean match(IPropertyGroup property) {
                    return true;
                }

                @Override
                public IGroupRenderer createRenderer(IPropertyGroup group) {
                    if (group.getParentId() == null) {
                        if (PropertyControl.this.isFlat()) {
                            return new FlatGroupRenderer();
                        }
                        return new CTabGroupRenderer();
                    }
                    return new DefaultGroupRenderer();
                }
            });
        }
    }

    protected String getGroupName(IPropertyGroup group) {
        if (group.getName() == null || group.getName().length() == 0) {
            return "";
        }
        return String.valueOf(' ') + group.getName() + ' ';
    }

    public Control createControl(Composite parent) {
        IPropertyContext context = this.getPropertyContext();
        IRendererContext rendererContext = this.getRendererContext();
        IRenderers renderers = this.getRendererContext().getRenderers();
        if (context == null || renderers == null) {
            return parent;
        }
        IProperties properties = context.getProperties();
        Composite topLevel = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        topLevel.setLayout((Layout)mainLayout);
        topLevel.setLayoutData((Object)new GridData(1808));
        boolean isFlat = this.isFlat();
        CTabFolder tabFolder = null;
        if (!isFlat) {
            tabFolder = new CTabFolder(topLevel, 128);
            tabFolder.setBorderVisible(true);
            tabFolder.setLayoutData((Object)new GridData(1808));
            tabFolder.setLayout((Layout)new GridLayout());
        }
        int i = 0;
        for (IPropertyGroup mainGroup : renderers.getGroups(properties, IPropertyGroup.EMPTY)) {
            rendererContext.putParameter("PARAMETER_GROUP_INDEX", i);
            rendererContext.putParameter("PARAMETER_TAB_FOLDER", tabFolder);
            IGroupRenderer groupRenderer = rendererContext.getRenderer(mainGroup);
            ++i;
            if (groupRenderer == null) continue;
            groupRenderer.render(topLevel, rendererContext);
        }
        return topLevel;
    }
}

