/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.ui.tabbed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyGroup;
import org.polarsys.capella.common.flexibility.wizards.group.renderer.DefaultGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.group.renderer.FlatGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.policy.AbstractRendererPolicy;
import org.polarsys.capella.common.flexibility.wizards.policy.IPolicifiedRendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.services.helper.FormHelper;

public class PropertiesSection
extends AbstractPropertySection {
    IPropertyContext propertyContext;
    IRendererContext rendererContext;
    IPropertyGroup group;

    public PropertiesSection(IPropertyContext context, IRendererContext renderers, IPropertyGroup group) {
        this.init(context, renderers, group);
    }

    protected PropertiesSection() {
    }

    protected void init(IPropertyContext context, IRendererContext renderers, IPropertyGroup group) {
        this.propertyContext = context;
        this.group = group;
        this.rendererContext = renderers;
        this.initRendererContext(this.rendererContext);
    }

    protected void initRendererContext(final IRendererContext rendererContext) {
        if (rendererContext instanceof IPolicifiedRendererContext) {
            ((IPolicifiedRendererContext)((Object)rendererContext)).addRendererPolicy(new AbstractRendererPolicy(){

                @Override
                public boolean match(IPropertyGroup group) {
                    return true;
                }

                @Override
                public IGroupRenderer createRenderer(IPropertyGroup group) {
                    for (IPropertyGroup grp : rendererContext.getPropertyContext().getProperties().getGroups(IPropertyGroup.EMPTY)) {
                        if (!grp.getId().equals(group.getParentId())) continue;
                        return new FlatGroupRenderer();
                    }
                    return new DefaultGroupRenderer(){

                        @Override
                        protected boolean isDisplayLabel(IPropertyGroup group) {
                            return true;
                        }

                        @Override
                        protected String getGroupName(IPropertyGroup group) {
                            return "";
                        }
                    };
                }
            });
        }
    }

    protected void write(final IPropertyContext context) {
        if (context != null && context.isModified()) {
            AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                public String getName() {
                    return "Model edition";
                }

                public void run() {
                    context.writeAll();
                }
            };
            TransactionHelper.getExecutionManager((Collection)context.getSourceAsList()).execute((ICommand)cmd);
        }
    }

    protected Object getSource(ISelection selection) {
        ArrayList objects = new ArrayList();
        Iterator e = ((IStructuredSelection)selection).iterator();
        while (e.hasNext()) {
            objects.add(e.next());
        }
        if (objects.size() == 1) {
            return objects.iterator().next();
        }
        return objects;
    }

    protected void setContext(ISelection selection) {
        this.propertyContext.setSource(this.getSource(selection));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        this.write(this.propertyContext);
        this.propertyContext.setSource(this.getSource(selection));
        super.setInput(part, selection);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
    }

    public void dispose() {
        this.write(this.propertyContext);
        for (IProperty property : this.propertyContext.getProperties().getAllItems()) {
            IPropertyRenderer renderer = this.rendererContext.getRenderer(property);
            if (renderer == null) continue;
            renderer.dispose(this.rendererContext);
        }
        super.dispose();
    }

    public void aboutToBeHidden() {
        this.write(this.propertyContext);
        super.aboutToBeHidden();
    }

    protected ILabelProvider getLabelProvider() {
        return this.rendererContext.getLabelProvider();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        IGroupRenderer groupRenderer = this.rendererContext.getRenderer(this.group);
        if (groupRenderer != null) {
            groupRenderer.render(comp, this.rendererContext);
        }
        if (aTabbedPropertySheetPage != null) {
            FormHelper.adaptBackgroundColor((Control)comp, (Color)aTabbedPropertySheetPage.getWidgetFactory().getColors().getBackground(), (boolean)false);
        }
        comp.pack();
    }
}

