/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionTargetViewer;
import org.polarsys.capella.core.ui.toolkit.decomposition.Messages;

public class RenameDecompositionDialog
extends PopupDialog {
    private CTabItem _item;
    private Point _location;
    private DecompositionTargetViewer _viewer;
    List<Control> exclusions = new ArrayList<Control>();

    public RenameDecompositionDialog(Shell parent_p, int shellStyle_p, boolean takeFocusOnOpen_p, boolean persistBounds_p, boolean showDialogMenu_p, boolean showPersistAction_p, String titleText_p, String infoText_p, TabItem item_p, Point point_p, DecompositionTargetViewer viewer_p) {
        super(parent_p, shellStyle_p, takeFocusOnOpen_p, persistBounds_p, persistBounds_p, showDialogMenu_p, showPersistAction_p, titleText_p, infoText_p);
        this._location = point_p;
        this._viewer = viewer_p;
    }

    public RenameDecompositionDialog(Shell parent_p, int shellStyle_p, boolean takeFocusOnOpen_p, boolean persistBounds_p, boolean showDialogMenu_p, boolean showPersistAction_p, String titleText_p, String infoText_p, CTabItem item_p, Point point_p, DecompositionTargetViewer viewer_p) {
        super(parent_p, shellStyle_p, takeFocusOnOpen_p, persistBounds_p, persistBounds_p, showDialogMenu_p, showPersistAction_p, titleText_p, infoText_p);
        this._item = item_p;
        this._location = point_p;
        this._viewer = viewer_p;
    }

    protected Point getInitialLocation(Point initialSize_p) {
        CTabFolder folder = this._item.getParent();
        Rectangle rect = folder.getBounds();
        Point pt = folder.toDisplay(rect.x + this._location.x, rect.y - folder.getLocation().y + this._location.y);
        return pt;
    }

    protected Control createDialogArea(Composite parent_p) {
        final Text text = new Text(parent_p, 0x1000000);
        this.exclusions.add((Control)text);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0_p) {
            }

            public void keyReleased(KeyEvent ke_p) {
                try {
                    String str = text.getText();
                    if (str != null && str.trim().length() > 0) {
                        DecompositionModel model = RenameDecompositionDialog.this._viewer.getDecompositionModel();
                        if (!model.isValidName(str.trim())) {
                            RenameDecompositionDialog.this._viewer.showErrorMessage(Messages.getString("LCDecompGeneralViewer.decomp.rename.errormsg"));
                        } else {
                            RenameDecompositionDialog.this._viewer.showErrorMessage(null);
                            int enterKey = KeyStroke.getInstance((String)"ENTER").getNaturalKey();
                            int numpadEnterKey = KeyStroke.getInstance((String)"NUMPAD_ENTER").getNaturalKey();
                            if (ke_p.keyCode == enterKey || ke_p.keyCode == numpadEnterKey) {
                                Event event = new Event();
                                event.data = str.trim();
                                RenameDecompositionDialog.this._item.notifyListeners(8, event);
                                RenameDecompositionDialog.this.close();
                            }
                        }
                    }
                }
                catch (ParseException exception_p) {
                    exception_p.printStackTrace();
                }
            }
        });
        return text;
    }

    protected Control createInfoTextArea(Composite parent_p) {
        Control ctrl = super.createInfoTextArea(parent_p);
        this.exclusions.add(ctrl);
        return ctrl;
    }

    protected List getBackgroundColorExclusions() {
        this.exclusions.addAll(super.getBackgroundColorExclusions());
        return this.exclusions;
    }
}

