/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.eval;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;

public class ENodeList {
    protected List list = new ArrayList();
    protected boolean unique;

    public ENodeList() {
        this(false);
    }

    public ENodeList(boolean unique) {
        this.unique = unique;
    }

    public void add(ENode node) {
        if (node != null) {
            if (node.isList()) {
                try {
                    this.addAll(node.getList());
                }
                catch (ENodeCastException eNodeCastException) {}
            } else if (!node.isNull()) {
                if (this.unique) {
                    if (!this.list.contains(node)) {
                        this.list.add(node);
                    }
                } else {
                    this.list.add(node);
                }
            }
        }
    }

    public void add(int index, ENode node) {
        if (node != null) {
            if (node.isList()) {
                try {
                    this.addAll(index, node.getList());
                }
                catch (ENodeCastException eNodeCastException) {}
            } else if (!node.isNull()) {
                if (index < 0 || index >= this.list.size()) {
                    if (this.unique) {
                        if (!this.list.contains(node)) {
                            this.list.add(node);
                        }
                    } else {
                        this.list.add(node);
                    }
                } else if (this.unique) {
                    if (!this.list.contains(node)) {
                        this.list.add(index, node);
                    }
                } else {
                    this.list.add(index, node);
                }
            }
        }
    }

    public ENode get(int index) {
        if (index >= 0 && index < this.list.size()) {
            return (ENode)this.list.get(index);
        }
        return null;
    }

    public void remove(ENode node) {
        this.list.remove(node);
    }

    public void addAll(ENodeList other) {
        ENodeIterator it = other.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    private void addAll(int index, ENodeList other) {
        ENodeIterator it = other.iterator();
        while (it.hasNext()) {
            this.add(index, it.next());
        }
    }

    public ENodeIterator iterator() {
        return new ENodeIterator(this);
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    public boolean contains(ENode node) {
        return this.list.contains(node);
    }

    public int size() {
        return this.list.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("");
        ENodeIterator it = this.iterator();
        while (it.hasNext()) {
            buffer.append(it.next().toString());
        }
        return buffer.toString();
    }

    public void sort() {
        TreeSet set = new TreeSet(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((ENode)arg0).compareTo(arg1);
            }
        });
        set.addAll(this.list);
        this.list = new ArrayList(set);
    }

    public List asList() {
        ArrayList<Object> result = new ArrayList<Object>();
        ENodeIterator it = this.iterator();
        while (it.hasNext()) {
            result.add(it.next().getValue());
        }
        return result;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof ENodeList) {
            return this.list.equals(((ENodeList)arg0).list);
        }
        return false;
    }
}

