/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.scripts.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.query.legacy.ecore.factories.EFactory;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.eval.log.EvalFailure;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateCallExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IEvalSettings;

public class EvalModel
implements IEvalSettings {
    protected String uri;
    protected EPackage metamodel;
    private final boolean logErrors;

    public EvalModel(String uri) {
        this(uri, true);
    }

    public EvalModel(String uri, boolean logErrors) {
        this.uri = uri;
        this.logErrors = logErrors;
        this.metamodel = ETools.uri2EPackage(uri, false);
    }

    public String getUri() {
        return this.uri;
    }

    public EPackage getMetamodel() {
        return this.metamodel;
    }

    @Override
    public ENode eGet(TemplateCallExpression call, ENode node, ENode[] args, LaunchManager mode, boolean recursiveSearch) throws FactoryException, ENodeException {
        if (args.length == 0) {
            return this.eGetSub(call, node, args, mode);
        }
        return null;
    }

    private ENode eGetSub(TemplateCallExpression call, ENode node, ENode[] args, LaunchManager mode) throws FactoryException, ENodeException {
        boolean isNaming;
        ENode eval;
        EObject eObject = null;
        if (node.isEObject()) {
            try {
                eObject = node.getEObject();
                node = new ENode(eObject, call, mode.isSynchronize());
            }
            catch (ENodeCastException eNodeCastException) {
                eObject = null;
            }
        }
        if (eObject != null && EFactory.eValid(eObject, call.getLink()) && call.countArguments() == 0) {
            boolean hasMetaPrefix = TemplateConstants.LINK_PREFIX_METAMODEL.equals(call.getPrefix()) || TemplateConstants.LINK_PREFIX_METAMODEL_SHORT.equals(call.getPrefix());
            Object object = EFactory.eGet(eObject, call.getLink(), !hasMetaPrefix);
            eval = this.eGetHolder(object, node);
            EStructuralFeature feature = eObject.eClass().getEStructuralFeature(call.getLink());
            if (feature != null) {
                boolean containment = feature == null || !(feature instanceof EReference) || ((EReference)feature).isContainment();
                eval.setContainment(containment);
                boolean optional = feature != null && feature instanceof EReference && ((EReference)feature).getLowerBound() == 0;
                eval.setOptional(optional);
            }
        } else {
            eval = null;
        }
        try {
            isNaming = call.getNextCall() != null && call.getNextCall().getLink().equals("naming") && call.countArguments() == 0 && call.getNextCall().countArguments() == 0 && node.isEObject() && (eval == null || eval.isNull() || eval.isEObject() && eval.getEObject().eContainer() == null);
        }
        catch (ENodeCastException eNodeCastException) {
            isNaming = false;
        }
        if (isNaming) {
            try {
                String otherLink = String.valueOf(call.getLink()) + "Value";
                String result = EFactory.eGetAsString(eObject, otherLink);
                if (result != null) {
                    ENode otherEval = new ENode(result, node);
                    if (this.logErrors) {
                        otherEval.log().addError(new EvalFailure(AcceleoGenMessages.getString("EvalModel.EvaluationEmptyNaming", new Object[]{otherLink, node.getEObject().eClass().getName(), call.getLink()})));
                    }
                    call.getNextCall().ignoreNextEval();
                    return otherEval;
                }
            }
            catch (ENodeCastException eNodeCastException) {
            }
            catch (FactoryException factoryException) {}
        }
        return eval;
    }

    private ENode eGetHolder(Object object, ENode node) throws ENodeException {
        ENode result = ENode.createTry(object, node);
        if (result == null) {
            result = new ENode(ENode.EMPTY, node);
        }
        return result;
    }

    @Override
    public Object resolveType(Object type, TemplateCallExpression call, int depth) {
        if (type != null) {
            if (type instanceof EClass) {
                Object result = null;
                if (call.countArguments() == 0) {
                    result = this.checkingForFeature((EClass)type, call.getLink());
                    if (result == null) {
                        result = this.checkingForOperation((EClass)type, call.getLink(), call.countArguments());
                    }
                } else {
                    result = this.checkingForOperation((EClass)type, call.getLink(), call.countArguments());
                }
                return result;
            }
            if (type == IEvalSettings.GENERIC_TYPE) {
                return type;
            }
        }
        return null;
    }

    private Object checkingForFeature(EClass eClass, String link) {
        EStructuralFeature feature = eClass.getEStructuralFeature(link);
        if (feature != null) {
            EClassifier result = feature.getEType();
            if (!"http://www.eclipse.org/emf/2002/Ecore".equals(this.uri) && result == EcorePackage.eINSTANCE.getEObject()) {
                return IEvalSettings.GENERIC_TYPE;
            }
            return result;
        }
        return null;
    }

    private Object checkingForOperation(EClass eClass, String link, int argCount) {
        EOperation operation = null;
        for (EOperation currentOp : eClass.getEAllOperations()) {
            if (!currentOp.getName().equals(link) || currentOp.getEParameters().size() != argCount) continue;
            operation = currentOp;
            break;
        }
        if (operation != null) {
            EClassifier result = operation.getEType();
            if (result == EcorePackage.eINSTANCE.getEObject()) {
                return IEvalSettings.GENERIC_TYPE;
            }
            return result;
        }
        return null;
    }

    @Override
    public Object[] getCompletionProposals(Object type, int depth) {
        ArrayList result = new ArrayList();
        if (type != null && type instanceof EClass) {
            result.addAll(this.getStructuralFeaturesProposals((EClass)type));
            result.addAll(this.getOperationProposals((EClass)type));
            return result.toArray();
        }
        return new Object[0];
    }

    private Collection getStructuralFeaturesProposals(EClass eClass) {
        TreeSet result = new TreeSet(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EStructuralFeature f0 = (EStructuralFeature)arg0;
                EStructuralFeature f1 = (EStructuralFeature)arg1;
                return f0.getName().compareTo(f1.getName());
            }
        });
        result.addAll(eClass.getEAllStructuralFeatures());
        return result;
    }

    private Collection getOperationProposals(EClass eClass) {
        TreeSet<EOperation> result = new TreeSet<EOperation>(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EOperation o0 = (EOperation)arg0;
                EOperation o1 = (EOperation)arg1;
                String o0tag = o0.getName();
                String o1tag = o1.getName();
                Iterator it = o0.getEParameters().iterator();
                while (it.hasNext()) {
                    o0tag = String.valueOf(o0tag) + ((EParameter)it.next()).getEType().getName();
                }
                it = o1.getEParameters().iterator();
                while (it.hasNext()) {
                    o1tag = String.valueOf(o1tag) + ((EParameter)it.next()).getEType().getName();
                }
                return o0tag.compareTo(o1tag);
            }
        });
        for (EOperation operation : eClass.getEAllOperations()) {
            if (operation.getEType() == null || ENode.getAdapterType(operation.getEType().getClass()) == null || operation.getEParameters().size() != 0 || "EObject".equals(operation.getEContainingClass().getName())) continue;
            result.add(operation);
        }
        return result;
    }

    @Override
    public boolean validateCall(TemplateCallExpression call) {
        return "".equals(call.getPrefix()) || TemplateConstants.LINK_PREFIX_METAMODEL.equals(call.getPrefix()) || TemplateConstants.LINK_PREFIX_METAMODEL_SHORT.equals(call.getPrefix());
    }
}

