/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.mdsofa.common.helper.MiscHelper;
import org.polarsys.capella.common.ui.services.helper.AdapterManagerHelper;
import org.polarsys.capella.common.ui.toolkit.viewers.ITreeLabelAdapter;
import org.polarsys.capella.common.ui.toolkit.viewers.Messages;
import org.polarsys.capella.common.ui.toolkit.viewers.RegExpTreeViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.AbstractData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.ListData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;

public class TreeAndListViewer
extends RegExpTreeViewer {
    private AbstractData _data;
    private IStructuredSelection _selection;
    private Text _statusBar;
    private Button _treeViewerModeButton;

    public TreeAndListViewer(Composite parent, boolean isMultipleSelection, int style, int viewerExpandLevel) {
        super(parent, isMultipleSelection, style, viewerExpandLevel);
    }

    public TreeAndListViewer(Composite parent, boolean isMultipleSelection, int style) {
        super(parent, isMultipleSelection, style, -1);
    }

    public TreeAndListViewer(Composite parent, Collection<? extends Object> displayedElements, boolean isMultipleSelection, ILabelProvider labelProvider) {
        this(parent, displayedElements, null, isMultipleSelection, labelProvider, 6, -1);
    }

    public TreeAndListViewer(Composite parent, Collection<? extends Object> displayedElements, Object context, boolean isMultipleSelection, IContentProvider contentProvider, ILabelProvider labelProvider, int style, int viewerExpandLevel) {
        super(parent, isMultipleSelection, style, viewerExpandLevel);
        TreeViewer viewer = this.getClientViewer();
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.setInput(displayedElements, context);
    }

    public TreeAndListViewer(Composite parent, Collection<? extends Object> displayedElements, Object context, boolean isMultipleSelection, ILabelProvider labelProvider, int style, int viewerExpandLevel) {
        this(parent, displayedElements, context, isMultipleSelection, (IContentProvider)new DataContentProvider(), labelProvider, style, viewerExpandLevel);
    }

    @Override
    protected void createControl(Composite parent) {
        super.createControl(parent);
        this.createTreeViewerModeButton(this.getControl());
        this.createStatusBar(this.getControl());
    }

    protected ListData createListDataWhenTreeViewModeClicked(TreeViewer viewer, List<?> displayedElements, Object context) {
        return new ListData((Collection<?>)displayedElements, context);
    }

    protected void createStatusBar(Composite parent) {
        if ((2 & this.getStyle()) != 0) {
            this._statusBar = new Text(parent, 2056);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.widthHint = this.getStatusBarWidthhint();
            this._statusBar.setLayoutData((Object)gridData);
        }
    }

    protected TreeData createTreeDataWhenTreeViewModeClicked(TreeViewer viewer, List<? extends Object> displayedElements, Object context) {
        return new TreeData(displayedElements, context);
    }

    protected void createTreeViewerModeButton(Composite parent) {
        if ((4 & this.getStyle()) != 0) {
            this._treeViewerModeButton = new Button(parent, 32);
            this._treeViewerModeButton.setText(Messages.getString("TreeAndListViewer_TreeViewerMode_Title"));
            this._treeViewerModeButton.setSelection((8 & this.getStyle()) == 0);
            this._treeViewerModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TreeAndListViewer.this.handleTreeViewModeClicked(((Button)event.widget).getSelection(), TreeAndListViewer.this.getClientViewer());
                }
            });
        }
    }

    @Override
    protected TreeViewer doClientViewer(Composite parent) {
        TreeViewer viewer = super.doClientViewer(parent);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeAndListViewer.this._selection = (IStructuredSelection)event.getSelection();
                if (TreeAndListViewer.this._selection.size() == 1) {
                    TreeAndListViewer.this.updateStatusBar(TreeAndListViewer.this._selection.toList().get(0));
                } else {
                    TreeAndListViewer.this.updateStatusBar(null);
                }
            }
        });
        viewer.setAutoExpandLevel(this._viewerExpandLevel);
        return viewer;
    }

    public AbstractData getData() {
        return this._data;
    }

    public Object getFirstElement() {
        Object result = null;
        ISelection selection = this.getSelection();
        if (selection != null && !selection.isEmpty()) {
            result = ((IStructuredSelection)selection).getFirstElement();
        }
        return result;
    }

    @Override
    public ISelection getSelection() {
        return this._selection;
    }

    @Override
    protected int getTreeStyle() {
        return 0x10000 | (this._isMultipleSelection ? 2 : 4) | 0x800 | 0x200;
    }

    protected void handleTreeViewModeClicked(boolean checked, TreeViewer viewer) {
        AbstractData currentInitialInput = (AbstractData)viewer.getInput();
        AbstractData newInitialInput = null;
        newInitialInput = checked ? this.createTreeDataWhenTreeViewModeClicked(viewer, MiscHelper.asList((Object[])currentInitialInput.getElements()), currentInitialInput.getContext()) : this.createListDataWhenTreeViewModeClicked(viewer, currentInitialInput.getValidElements(), currentInitialInput.getContext());
        newInitialInput.setNotifiedForValidElementsChanges(currentInitialInput.getNotifiedForValidElementsChanges());
        viewer.setInput((Object)newInitialInput);
    }

    public boolean isValidElement(Object element) {
        return this._data.isValid(element);
    }

    public void setInput(Collection<? extends Object> displayedElements, Object context) {
        boolean hierarchicalDisplay;
        boolean bl = hierarchicalDisplay = (8 & this.getStyle()) == 0;
        if (this._treeViewerModeButton != null && !this._treeViewerModeButton.isDisposed()) {
            hierarchicalDisplay = this._treeViewerModeButton.getSelection();
        }
        this._data = hierarchicalDisplay ? new TreeData(displayedElements, context) : new ListData((Collection<?>)displayedElements, context);
        this.getClientViewer().setInput((Object)this._data);
    }

    public void setSelectionListener(ISelectionChangedListener listener) {
        this.getClientViewer().addSelectionChangedListener(listener);
    }

    public void setAutoExpandLevel(int expandLevel) {
        this.getClientViewer().setAutoExpandLevel(expandLevel);
    }

    protected void updateStatusBar(Object selectedElement) {
        if (this._statusBar == null || this._statusBar.isDisposed()) {
            return;
        }
        ITreeLabelAdapter treeLabelAdapter = (ITreeLabelAdapter)AdapterManagerHelper.getAdapter(selectedElement, ITreeLabelAdapter.class);
        if (treeLabelAdapter != null) {
            this._statusBar.setText(treeLabelAdapter.getFullLabel());
        } else {
            this._statusBar.setText("");
        }
    }

    protected int getStatusBarWidthhint() {
        return 10;
    }
}

