/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.api;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.polarsys.kitalpha.composer.extension.points.CodeManagerExtensions;
import org.polarsys.kitalpha.composer.extension.points.IGenerator;
import org.polarsys.kitalpha.composer.extension.points.IRefinery;
import org.polarsys.kitalpha.composer.extension.points.IStrategy;

public class CodeManagerRegistry {
    private static IConfigurationElement config = null;

    public static IStrategy getStrategyFromName(String name) throws CoreException {
        IStrategy strategy = null;
        config = CodeManagerExtensions.getStrategyConfigElement(name);
        if (config != null) {
            strategy = (IStrategy)config.createExecutableExtension("Class");
        }
        return strategy;
    }

    public static IRefinery getRefineryFromName(String name) throws CoreException {
        IRefinery refinery = null;
        config = CodeManagerExtensions.getRefineryConfigElement(name);
        if (config != null) {
            refinery = (IRefinery)config.createExecutableExtension("Class");
        }
        return refinery;
    }

    public static IGenerator getGeneratorFromName(String name) throws CoreException {
        IGenerator generator = null;
        config = CodeManagerExtensions.getGeneratorConfigElement(name);
        if (config != null) {
            generator = (IGenerator)config.createExecutableExtension("Class");
        }
        return generator;
    }

    public static IStrategy getStrategyFromId(String id) throws CoreException {
        IStrategy strategy = null;
        config = CodeManagerExtensions.getStrategyConfigElementFromId(id);
        if (config != null) {
            strategy = (IStrategy)config.createExecutableExtension("Class");
        }
        return strategy;
    }

    public static IRefinery getRefineryFromId(String id) throws CoreException {
        IRefinery refinery = null;
        config = CodeManagerExtensions.getRefineryConfigElementFromId(id);
        if (config != null) {
            refinery = (IRefinery)config.createExecutableExtension("Class");
        }
        return refinery;
    }

    public static IGenerator getGeneratorFromId(String id) throws CoreException {
        IGenerator generator = null;
        config = CodeManagerExtensions.getGeneratorConfigElementFromId(id);
        if (config != null) {
            generator = (IGenerator)config.createExecutableExtension("Class");
        }
        return generator;
    }
}

