/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.ui.handlers.merge;

import java.util.HashMap;
import org.eclipse.emf.diffmerge.ui.viewers.CategoryManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategory;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategorySet;
import org.eclipse.emf.diffmerge.ui.viewers.categories.DifferenceCategorySet;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.transition.common.handlers.merge.ICategoryItem;
import org.polarsys.capella.core.transition.common.handlers.merge.ICategorySet;
import org.polarsys.capella.core.transition.common.ui.handlers.merge.DiffCategoryProxy;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MergeCategoryManager
extends CategoryManager {
    IContext context;
    HashMap<String, IDifferenceCategorySet> sets = new HashMap();

    public MergeCategoryManager(EMFDiffNode node, IContext context) {
        super(node);
        this.context = context;
    }

    public boolean addCategory(IDifferenceCategory category) {
        IDifferenceCategorySet set;
        IDifferenceCategory squatter = this.getCategory(category.getID());
        if (squatter != null) {
            if (squatter.getParent() != null) {
                squatter.getParent().getChildren().remove((Object)squatter);
            }
            this.removeCategory(category.getID());
        }
        if ((set = category.getParent()) != null && !set.getChildren().contains((Object)category)) {
            set.getChildren().add((Object)category);
        }
        return super.addCategory(category);
    }

    public boolean addCategories(IDifferenceCategorySet categorySet_p) {
        if (!this.sets.containsKey(categorySet_p.getText(this._node))) {
            this.sets.put(categorySet_p.getText(this._node), categorySet_p);
        }
        return super.addCategories(categorySet_p);
    }

    public void addCategorySet(ICategorySet categorySet) {
        DifferenceCategorySet category = new DifferenceCategorySet(categorySet.getId(), categorySet.getDescription());
        this.addCategories((IDifferenceCategorySet)category);
        category.setText(categorySet.getText());
    }

    public boolean addCategory(ICategoryItem category) {
        String parent = category.getCategorySet();
        DiffCategoryProxy cat = new DiffCategoryProxy(category);
        if (parent != null) {
            cat.setParent(this.getOrCreateCategorySet(parent));
        }
        return this.addCategory(cat);
    }

    public IDifferenceCategorySet getCategorySet(String id) {
        return this.sets.get(id);
    }

    public IDifferenceCategorySet getOrCreateCategorySet(String id) {
        if (!this.sets.containsKey(id)) {
            this.sets.put(id, (IDifferenceCategorySet)new DifferenceCategorySet(id));
        }
        return this.sets.get(id);
    }

    public void setDefaultConfiguration() {
        if (!this.hasDefaultConfiguration()) {
            super.setDefaultConfiguration();
        }
    }

    protected boolean hasDefaultConfiguration() {
        return !this._defaultConfiguration.isEmpty();
    }

    public void initializeFromPreferences() {
        Object purposeValue = this.context.get((Object)"TRANSPOSER_PURPOSE");
        if (purposeValue instanceof String) {
            String purpose = (String)purposeValue;
            ScopedCapellaPreferencesStore scps = ScopedCapellaPreferencesStore.getInstance((String)"org.polarsys.capella.core.preferences");
            for (IDifferenceCategory category : this.getCategories()) {
                String isActiveKey = this.getIsActiveKey(purpose, category);
                scps.setDefault(isActiveKey, category.isActive());
                if (scps.containsKey(isActiveKey)) {
                    boolean active = scps.getBoolean(isActiveKey);
                    category.setActive(active);
                }
                String inFocusModeKey = this.getIsInFocusModeKey(purpose, category);
                scps.setDefault(inFocusModeKey, category.isInFocusMode());
                if (!scps.containsKey(inFocusModeKey)) continue;
                boolean inFocusMode = scps.getBoolean(inFocusModeKey);
                category.setInFocusMode(inFocusMode);
            }
        }
    }

    public void saveToPreferences() {
        Object purposeValue = this.context.get((Object)"TRANSPOSER_PURPOSE");
        if (purposeValue instanceof String) {
            String purpose = (String)purposeValue;
            ScopedCapellaPreferencesStore scps = ScopedCapellaPreferencesStore.getInstance((String)"org.polarsys.capella.core.preferences");
            for (IDifferenceCategory category : this.getCategories()) {
                String isActiveKey = this.getIsActiveKey(purpose, category);
                scps.setValue(isActiveKey, category.isActive());
                String isInFocusModeKey = this.getIsInFocusModeKey(purpose, category);
                scps.setValue(isInFocusModeKey, category.isInFocusMode());
            }
            scps.save();
        }
    }

    public void update() {
        super.update();
        this.saveToPreferences();
    }

    public String getIsActiveKey(String purpose, IDifferenceCategory category) {
        return String.valueOf(purpose) + "_" + category.getID() + "_isActive";
    }

    public String getIsInFocusModeKey(String purpose, IDifferenceCategory category) {
        return String.valueOf(purpose) + "_" + category.getID() + "_isInFocusMode";
    }
}

