/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.core.properties.sections.GeneralizableElementSection;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.properties.controllers.AllocatedFunctionsController;
import org.polarsys.capella.core.data.cs.properties.controllers.ImplementedInterfacesController;
import org.polarsys.capella.core.data.cs.properties.controllers.UsedInterfacesController;
import org.polarsys.capella.core.data.cs.properties.fields.IsActorCheckbox;
import org.polarsys.capella.core.data.cs.properties.fields.IsHumanCheckbox;
import org.polarsys.capella.core.data.cs.properties.sections.Messages;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;

public abstract class ComponentSection
extends GeneralizableElementSection {
    private boolean showIsHuman;
    private boolean showIsActor;
    private boolean showImplementedInterfaces;
    private boolean showUsedInterfaces;
    private boolean showAllocatedFunctions;
    protected IsHumanCheckbox isHumanCheckbox;
    protected IsActorCheckbox isActorCheckbox;
    private MultipleSemanticField implementedInterfaces;
    private MultipleSemanticField usedInterfaces;
    protected MultipleSemanticField allocatedFunctions;

    public ComponentSection() {
        this(true, true, true, true, true, true, true);
    }

    public ComponentSection(boolean showIsHuman, boolean showIsActor, boolean showImplementedInterfaces, boolean showUsedInterfaces, boolean showAllocatedFunctions, boolean showSuperTypes, boolean showIsAbstract) {
        super(showSuperTypes, showIsAbstract);
        this.showIsHuman = showIsHuman;
        this.showIsActor = showIsActor;
        this.showImplementedInterfaces = showImplementedInterfaces;
        this.showUsedInterfaces = showUsedInterfaces;
        this.showAllocatedFunctions = showAllocatedFunctions;
    }

    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createContents(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        if (this.showIsHuman) {
            this.isHumanCheckbox = new IsHumanCheckbox((Composite)this.getCheckGroup(), this.getWidgetFactory());
            this.isHumanCheckbox.setDisplayedInWizard(displayedInWizard);
        }
        if (this.showIsActor) {
            this.isActorCheckbox = new IsActorCheckbox((Composite)this.getCheckGroup(), this.getWidgetFactory());
            this.isActorCheckbox.setDisplayedInWizard(displayedInWizard);
        }
        if (this.showImplementedInterfaces) {
            this.implementedInterfaces = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.ComponentSection_ImplementedInterfaces_Label, this.getWidgetFactory(), (IMultipleSemanticFieldController)new ImplementedInterfacesController());
            this.implementedInterfaces.setDisplayedInWizard(displayedInWizard);
        }
        if (this.showUsedInterfaces) {
            this.usedInterfaces = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.ComponentSection_UsedInterfaces_Label, this.getWidgetFactory(), (IMultipleSemanticFieldController)new UsedInterfacesController());
            this.usedInterfaces.setDisplayedInWizard(displayedInWizard);
        }
        if (this.showAllocatedFunctions) {
            this.allocatedFunctions = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.ComponentSection_AllocatedFunctions_Label, this.getWidgetFactory(), (IMultipleSemanticFieldController)new AllocatedFunctionsController());
            this.allocatedFunctions.setDisplayedInWizard(displayedInWizard);
        }
    }

    public void loadData(EObject capellaElement) {
        boolean isASystem;
        super.loadData(capellaElement);
        Component component = (Component)capellaElement;
        BlockArchitecture block = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
        if (this.superTypes != null) {
            this.superTypes.setEnabled(component.isActor() || CapellaModelPreferencesPlugin.getDefault().isComponentNonActorInheritanceAllowed());
        }
        if (this.propertiesCheckbox != null) {
            this.propertiesCheckbox.setEnabled(component.isActor());
        }
        if (this.isHumanCheckbox != null) {
            this.isHumanCheckbox.loadData((EObject)component);
            boolean isAnOE = block instanceof OperationalAnalysis && !component.isActor();
            isASystem = component == block.getSystem();
            boolean hasChildren = ComponentExt.isComposite((Component)component);
            if (this.isHumanCheckbox.isEnabled() && (isAnOE || isASystem || hasChildren)) {
                this.isHumanCheckbox.setEnabled(false);
            }
        }
        if (this.isActorCheckbox != null) {
            boolean cannotBecameActor;
            this.isActorCheckbox.loadData((EObject)component);
            boolean isInSALevel = block instanceof SystemAnalysis;
            isASystem = component == block.getSystem();
            boolean cannotBecameComponent = component.isActor() && !ComponentExt.canCreateABComponent((EObject)component.eContainer());
            boolean bl = cannotBecameActor = !component.isActor() && !ComponentExt.canCreateABActor((EObject)component.eContainer());
            if (this.isActorCheckbox.isEnabled() && (isInSALevel || isASystem || cannotBecameComponent || cannotBecameActor)) {
                this.isActorCheckbox.setEnabled(false);
            }
        }
        if (this.implementedInterfaces != null) {
            this.implementedInterfaces.loadData((EObject)component, (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_INTERFACE_IMPLEMENTATIONS);
        }
        if (this.usedInterfaces != null) {
            this.usedInterfaces.loadData((EObject)component, (EStructuralFeature)CsPackage.Literals.COMPONENT__OWNED_INTERFACE_USES);
        }
        if (this.allocatedFunctions != null) {
            this.allocatedFunctions.loadData((EObject)component, (EStructuralFeature)FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK__OWNED_FUNCTIONAL_ALLOCATION);
        }
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.isHumanCheckbox);
        fields.add((AbstractSemanticField)this.isActorCheckbox);
        fields.add((AbstractSemanticField)this.allocatedFunctions);
        fields.add((AbstractSemanticField)this.implementedInterfaces);
        fields.add((AbstractSemanticField)this.usedInterfaces);
        return fields;
    }

    protected String getSuperLabel() {
        return Messages.GeneralizableComponentSection_Generalized_Label;
    }
}

