/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class DDiagramContents {
    protected DSemanticDiagram _currentDiagram;
    protected DiagramDescription _currentDescription;
    protected HashMapSet<EObject, DDiagramElement> _elementsTargets = null;
    protected HashSet<DDiagramElement> _elementsToShow = null;
    protected HashSet<DDiagramElement> _elementsToHide = null;
    protected HashMap<String, DiagramElementMapping> _mappings = null;

    public void deferredShow(DDiagramElement element) {
        this._elementsToShow.add(element);
        if (this._elementsToHide.contains(element)) {
            this._elementsToHide.remove(element);
        }
    }

    public void deferredHide(DDiagramElement element) {
        this._elementsToHide.add(element);
        if (this._elementsToShow.contains(element)) {
            this._elementsToShow.remove(element);
        }
    }

    public void commitDeferredActions() {
        for (DDiagramElement element : this._elementsToShow) {
            CapellaServices.getService().show(element);
        }
        this._elementsToShow.clear();
        for (DDiagramElement element : this._elementsToHide) {
            CapellaServices.getService().hide(element);
        }
        this._elementsToHide.clear();
    }

    public DDiagramContents(DDiagram diagram) {
        this._currentDiagram = (DSemanticDiagram)diagram;
        this._currentDescription = this._currentDiagram.getDescription();
        this._elementsToShow = new HashSet();
        this._elementsToHide = new HashSet();
    }

    public DDiagramContents(DDiagramContents diagramContent) {
        this._currentDiagram = diagramContent._currentDiagram;
        this._currentDescription = diagramContent.getDescription();
        this._elementsTargets = diagramContent._elementsTargets;
        this._elementsToShow = new HashSet();
        this._elementsToHide = new HashSet();
    }

    public DiagramDescription getDescription() {
        return this._currentDescription;
    }

    public DDiagram getDDiagram() {
        return this._currentDiagram;
    }

    private HashMapSet<EObject, DDiagramElement> getMapDiagramElements() {
        if (this._elementsTargets == null) {
            this._elementsTargets = new HashMapSet();
            for (DDiagramElement element : this.getDiagramElements()) {
                this._elementsTargets.put(element.getTarget(), element);
            }
        }
        return this._elementsTargets;
    }

    public void addView(DDiagramElement diagramElement) {
        this.getMapDiagramElements().put(diagramElement.getTarget(), diagramElement);
    }

    public void removeView(DDiagramElement diagramElement) {
        this.getMapDiagramElements().remove(diagramElement.getTarget(), diagramElement);
    }

    public Iterable<DDiagramElement> getDiagramElements() {
        return DiagramServices.getDiagramServices().getDiagramElements((EObject)this._currentDiagram);
    }

    public Iterable<DDiagramElement> getDiagramElements(DiagramElementMapping mapping) {
        return DiagramServices.getDiagramServices().getDiagramElements((DDiagram)this._currentDiagram, mapping);
    }

    public List<DDiagramElement> getVisibleDiagramElements(DiagramElementMapping mapping) {
        ArrayList<DDiagramElement> lstVisibleElements = new ArrayList<DDiagramElement>();
        for (DDiagramElement element : DiagramServices.getDiagramServices().getDiagramElements((DDiagram)this._currentDiagram, mapping)) {
            if (!element.isVisible()) continue;
            lstVisibleElements.add(element);
        }
        return lstVisibleElements;
    }

    public Iterable<DDiagramElement> getDiagramElements(DDiagramElement containerView, DiagramElementMapping mapping) {
        return DiagramServices.getDiagramServices().getDiagramElements(containerView, mapping);
    }

    public Iterable<DDiagramElement> getDiagramElements(DSemanticDecorator decorator, DiagramElementMapping mapping) {
        if (decorator instanceof DDiagram) {
            return this.getDiagramElements(mapping);
        }
        return this.getDiagramElements((DDiagramElement)decorator, mapping);
    }

    public <T> Collection<T> asList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(t);
        }
        return result;
    }

    public Collection<EObject> asSemantic(Iterable<?> iterable) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object t : iterable) {
            DSemanticDecorator view;
            if (!(t instanceof DSemanticDecorator) || result.contains((view = (DSemanticDecorator)t).getTarget())) continue;
            result.add(view.getTarget());
        }
        return result;
    }

    public Collection<DDiagramElement> getDiagramElements(EObject target) {
        return this.getMapDiagramElements().get(target);
    }

    public Collection<DDiagramElement> getDiagramElements(Collection<? extends EObject> target) {
        if (target.size() == 1) {
            return this.getDiagramElements(target.iterator().next());
        }
        if (target.size() > 1) {
            HashSet<DDiagramElement> elements = new HashSet<DDiagramElement>();
            for (EObject eObject : target) {
                elements.addAll(this.getDiagramElements(eObject));
            }
        }
        return Collections.emptyList();
    }

    public boolean containsView(EObject target) {
        return this.getMapDiagramElements().containsKey(target);
    }

    public boolean containsView(EObject target, DiagramElementMapping mapping) {
        if (!this.getMapDiagramElements().containsKey(target)) {
            return false;
        }
        if (mapping == null && this.getMapDiagramElements().containsKey(target)) {
            return true;
        }
        for (DDiagramElement view : this.getDiagramElements(target)) {
            if (mapping == null || !DiagramServices.getDiagramServices().isMapping(view, mapping)) continue;
            return true;
        }
        return false;
    }

    public Collection<DDiagramElement> getDiagramElements(EObject target, DiagramElementMapping mapping) {
        if (!this.getMapDiagramElements().containsKey(target)) {
            return Collections.emptyList();
        }
        if (mapping == null && this.getMapDiagramElements().containsKey(target)) {
            return this.getMapDiagramElements().get(target);
        }
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        Iterator iterator = this.getMapDiagramElements().get(target).iterator();
        while (iterator.hasNext()) {
            DDiagramElement view = (DDiagramElement)iterator.next();
            if (mapping == null || !DiagramServices.getDiagramServices().isMapping(view, mapping)) continue;
            result.add(view);
        }
        return result;
    }

    public Collection<DDiagramElement> getDiagramElements(EObject target, DiagramElementMapping mapping, DSemanticDecorator containerView) {
        if (!this.getMapDiagramElements().containsKey(target)) {
            return Collections.emptyList();
        }
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        Iterator iterator = this.getMapDiagramElements().get(target).iterator();
        while (iterator.hasNext()) {
            DDiagramElement view = (DDiagramElement)iterator.next();
            if (mapping != null && !DiagramServices.getDiagramServices().isMapping(view, mapping) || containerView != null && !EcoreUtil2.isContainedBy((EObject)view, (EObject)containerView)) continue;
            result.add(view);
        }
        return result;
    }

    public Collection<AbstractDNode> getNodes(EObject target) {
        return DiagramServices.getDiagramServices().filterNodes(this.getDiagramElements(target));
    }

    public Collection<DNodeContainer> getNodeContainers(EObject target) {
        return DiagramServices.getDiagramServices().filterNodeContainers(this.getDiagramElements(target));
    }

    public Collection<DEdge> getEdges(EObject target) {
        return DiagramServices.getDiagramServices().filterEdges(this.getDiagramElements(target));
    }

    @Deprecated
    public AbstractDNode getNode(EObject target) {
        Collection<AbstractDNode> elt = this.getNodes(target);
        if (!elt.isEmpty()) {
            return elt.iterator().next();
        }
        return null;
    }

    @Deprecated
    public DEdge getEdge(EObject target) {
        Collection<DEdge> elt = this.getEdges(target);
        if (!elt.isEmpty()) {
            return elt.iterator().next();
        }
        return null;
    }

    public DragAndDropTarget getBestContainer(DDiagramElement anElement) {
        EObject object = anElement.getTarget();
        DragAndDropTarget result = this.getBestContainer(object);
        if (result == null) {
            result = (DragAndDropTarget)anElement.eContainer();
        }
        return result;
    }

    public DragAndDropTarget getBestContainer(EObject semantic) {
        DDiagram diagram;
        EObject object = semantic;
        LinkedList<EObject> toVisit = new LinkedList<EObject>();
        if (object != null) {
            toVisit.addAll(this.getParents(object, semantic));
            while (!toVisit.isEmpty()) {
                EObject element = (EObject)toVisit.removeFirst();
                if (element == null) continue;
                if (this.containsView(element)) {
                    for (DDiagramElement dDiagramElement : this.getNodes(element)) {
                        if (!dDiagramElement.isVisible()) continue;
                        return (DragAndDropTarget)dDiagramElement;
                    }
                }
                toVisit.addAll(this.getParents(element, semantic));
            }
        }
        if ((diagram = this.getDDiagram()) instanceof DSemanticDiagram) {
            return diagram;
        }
        return null;
    }

    public Collection<EObject> getParents(EObject object, EObject context) {
        return Collections.singleton(object.eContainer());
    }

    public EObject getElement(EObject object, EObject context) {
        return object;
    }

    public Collection<DiagramElementMapping> getMappings(Collection<String> names) {
        ArrayList<DiagramElementMapping> result = new ArrayList<DiagramElementMapping>();
        for (String name : names) {
            result.add(this.getMapping(name));
        }
        return result;
    }

    public DiagramElementMapping getMapping(String name) {
        if (this._mappings == null) {
            this._mappings = DiagramServices.getDiagramServices().getAllMappingsByName(this.getDescription());
        }
        if (this._mappings.containsKey(name)) {
            return this._mappings.get(name);
        }
        return null;
    }

    public boolean isVisible(DDiagramElement edge) {
        if (this._elementsToHide.contains(edge)) {
            return false;
        }
        if (this._elementsToShow.contains(edge)) {
            return true;
        }
        return DiagramServices.getDiagramServices().isVisible(edge);
    }
}

