/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.constants;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.color.RGBValuesProvider;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.UserColorsPalette;
import org.eclipse.sirius.viewpoint.description.UserFixedColor;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class ColorNameConstants {
    public static final String ACTOR = "_CAP_Actor_Blue";
    private static final String COLOR_PALETTE = "Migration Palette";
    private static final URI COMMON = URI.createURI((String)"viewpoint:/org.polarsys.capella.core.sirius.analysis/Common");

    private ColorNameConstants() {
    }

    public static RGBValues get(String colorConstant) {
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(COMMON);
        Optional<UserColorsPalette> palette = ((Group)vp.eContainer()).getUserColorsPalettes().stream().filter(x -> COLOR_PALETTE.equals(x.getName())).findFirst();
        if (palette.isPresent()) {
            Optional<UserFixedColor> color = palette.get().getEntries().stream().filter(UserFixedColor.class::isInstance).map(UserFixedColor.class::cast).filter(x -> x.getName().equals(colorConstant)).findFirst();
            if (color.isPresent()) {
                return new RGBValuesProvider().getRGBValues((FixedColor)color.get());
            }
        }
        return null;
    }

    public static boolean equals(RGBValues value, String colorConstant) {
        RGBValues color = ColorNameConstants.get(colorConstant);
        if (color == null) {
            return value == null;
        }
        return color.equals((Object)value);
    }
}

