/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractCacheAwareRefreshExtension;

public class ContextualMissionRefreshExtension
extends AbstractCacheAwareRefreshExtension {
    @Override
    public void beforeRefresh(DDiagram diagram) {
        DNode container;
        super.beforeRefresh(diagram);
        if (((DSemanticDecorator)diagram).getTarget() == null) {
            return;
        }
        LinkedList<Component> actors = new LinkedList<Component>();
        LinkedList capabilities = new LinkedList();
        LinkedList<Mission> missions = new LinkedList<Mission>();
        NodeMapping actorNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "ActorNode");
        NodeMapping capaNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "CapNode");
        NodeMapping missionNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "MissionNode");
        Mission currentMission = (Mission)((DSemanticDecorator)diagram).getTarget();
        for (Involvement inv : currentMission.getInvolvedInvolvements()) {
            InvolvedElement involved = inv.getInvolved();
            if (!ComponentExt.isActor((EObject)involved)) continue;
            Component actor = (Component)involved;
            actors.add(actor);
            for (GeneralizableElement elt : actor.getSuper()) {
                if (!ComponentExt.isActor((EObject)elt)) continue;
                actors.add((Component)elt);
            }
        }
        missions.add(currentMission);
        capabilities.addAll(currentMission.getExploitedCapabilities());
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)currentMission);
        NodeMappingHelper nodeMappingHelper = new NodeMappingHelper(interpreter);
        for (Component actor : actors) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)actor)) continue;
            container = nodeMappingHelper.createNode(actorNodeMapping, (EObject)actor, (EObject)currentMission, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
        for (Capability cap : capabilities) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)cap)) continue;
            container = nodeMappingHelper.createNode(capaNodeMapping, (EObject)cap, (EObject)currentMission, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
        for (Mission mission : missions) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)mission)) continue;
            container = nodeMappingHelper.createNode(missionNodeMapping, (EObject)mission, (EObject)currentMission, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
    }
}

