/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public interface ColorConstants {
    public static final Color buttonLightest = ColorProvider.SystemColorFactory.colorProvider.getButtonLightest();
    public static final Color button = ColorProvider.SystemColorFactory.colorProvider.getButton();
    public static final Color buttonDarker = ColorProvider.SystemColorFactory.colorProvider.getButtonDarker();
    public static final Color buttonDarkest = ColorProvider.SystemColorFactory.colorProvider.getButtonDarkest();
    public static final Color listBackground = ColorProvider.SystemColorFactory.colorProvider.getListBackground();
    public static final Color listForeground = ColorProvider.SystemColorFactory.colorProvider.getListForeground();
    public static final Color lineForeground = ColorProvider.SystemColorFactory.colorProvider.getLineForeground();
    public static final Color menuBackground = ColorProvider.SystemColorFactory.colorProvider.getMenuBackground();
    public static final Color menuForeground = ColorProvider.SystemColorFactory.colorProvider.getMenuForeground();
    public static final Color menuBackgroundSelected = ColorProvider.SystemColorFactory.colorProvider.getMenuBackgroundSelected();
    public static final Color menuForegroundSelected = ColorProvider.SystemColorFactory.colorProvider.getMenuForegroundSelected();
    public static final Color titleBackground = ColorProvider.SystemColorFactory.colorProvider.getTitleBackground();
    public static final Color titleGradient = ColorProvider.SystemColorFactory.colorProvider.getTitleGradient();
    public static final Color titleForeground = ColorProvider.SystemColorFactory.colorProvider.getTitleForeground();
    public static final Color titleInactiveForeground = ColorProvider.SystemColorFactory.colorProvider.getTitleInactiveForeground();
    public static final Color titleInactiveBackground = ColorProvider.SystemColorFactory.colorProvider.getTitleInactiveBackground();
    public static final Color titleInactiveGradient = ColorProvider.SystemColorFactory.colorProvider.getTitleInactiveGradient();
    public static final Color tooltipForeground = ColorProvider.SystemColorFactory.colorProvider.getTooltipForeground();
    public static final Color tooltipBackground = ColorProvider.SystemColorFactory.colorProvider.getTooltipBackground();
    public static final Color listHoverBackgroundColor = ColorProvider.SystemColorFactory.colorProvider.getListHoverBackgroundColor();
    public static final Color listSelectedBackgroundColor = ColorProvider.SystemColorFactory.colorProvider.getListSelectedBackgroundColor();
    public static final Color white = new Color(null, 255, 255, 255);
    public static final Color lightGray = new Color(null, 192, 192, 192);
    public static final Color gray = new Color(null, 128, 128, 128);
    public static final Color darkGray = new Color(null, 64, 64, 64);
    public static final Color black = new Color(null, 0, 0, 0);
    public static final Color red = new Color(null, 255, 0, 0);
    public static final Color orange = new Color(null, 255, 196, 0);
    public static final Color yellow = new Color(null, 255, 255, 0);
    public static final Color green = new Color(null, 0, 255, 0);
    public static final Color lightGreen = new Color(null, 96, 255, 96);
    public static final Color darkGreen = new Color(null, 0, 127, 0);
    public static final Color cyan = new Color(null, 0, 255, 255);
    public static final Color lightBlue = new Color(null, 127, 127, 255);
    public static final Color blue = new Color(null, 0, 0, 255);
    public static final Color darkBlue = new Color(null, 0, 0, 127);

    public static class SystemColorFactory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Color getColor(final int which) {
            Display display = Display.getCurrent();
            if (display != null) {
                return display.getSystemColor(which);
            }
            display = Display.getDefault();
            final Color[] result = new Color[1];
            display.syncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Color[] colorArray = result;
                    synchronized (result) {
                        result[0] = Display.getCurrent().getSystemColor(which);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            Color[] colorArray = result;
            synchronized (result) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return result[0];
            }
        }
    }
}

